/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.hash.Hasher;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentsAndState;
import org.projectnessie.versioned.persist.adapter.ContentsId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableKeyList;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;

public abstract class AbstractDatabaseAdapter<OP_CONTEXT, CONFIG extends DatabaseAdapterConfig>
implements DatabaseAdapter {
    protected final CONFIG config;
    public static final Hash NO_ANCESTOR = Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])DatabaseAdapterUtil.newHasher().putString((CharSequence)"empty", StandardCharsets.UTF_8).hash().asBytes()));
    protected static long COMMIT_LOG_HASH_SEED = 946928273206945677L;

    protected AbstractDatabaseAdapter(CONFIG config) {
        Objects.requireNonNull(config, "config parameter must not be null");
        this.config = config;
    }

    @Override
    public Hash toHash(NamedRef ref) throws ReferenceNotFoundException {
        return this.hashOnReference(ref, Optional.empty());
    }

    @Override
    public Hash noAncestorHash() {
        return NO_ANCESTOR;
    }

    protected long commitTimeInMicros() {
        Instant instant = this.config.getClock().instant();
        long time = instant.getEpochSecond();
        long nano = instant.getNano();
        return TimeUnit.SECONDS.toMicros(time) + TimeUnit.NANOSECONDS.toMicros(nano);
    }

    protected CommitLogEntry commitAttempt(OP_CONTEXT ctx, long timeInMicros, Hash branchHead, CommitAttempt commitAttempt, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException, ReferenceConflictException {
        ArrayList<String> mismatches = new ArrayList<String>();
        this.checkExpectedGlobalStates(ctx, commitAttempt, mismatches::add);
        this.checkForModifiedKeysBetweenExpectedAndCurrentCommit(ctx, commitAttempt, branchHead, mismatches);
        if (!mismatches.isEmpty()) {
            throw new ReferenceConflictException(String.join((CharSequence)"\n", mismatches));
        }
        CommitLogEntry currentBranchEntry = this.fetchFromCommitLog(ctx, branchHead);
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> newParents = new ArrayList<Hash>(parentsPerCommit);
        newParents.add(branchHead);
        if (currentBranchEntry != null) {
            List<Hash> p = currentBranchEntry.getParents();
            newParents.addAll(p.subList(0, Math.min(p.size(), parentsPerCommit - 1)));
        }
        CommitLogEntry newBranchCommit = this.buildIndividualCommit(ctx, timeInMicros, newParents, commitAttempt.getCommitMetaSerialized(), commitAttempt.getPuts(), commitAttempt.getDeletes(), currentBranchEntry != null ? currentBranchEntry.getKeyListDistance() : 0, newKeyLists);
        this.writeIndividualCommit(ctx, newBranchCommit);
        return newBranchCommit;
    }

    protected Hash mergeAttempt(OP_CONTEXT ctx, long timeInMicros, Hash from, BranchName toBranch, Optional<Hash> expectedHead, Hash toHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException, ReferenceConflictException {
        this.validateHashExists(ctx, from);
        this.hashOnRef(ctx, (NamedRef)toBranch, expectedHead, toHead);
        Hash commonAncestor = this.findCommonAncestor(ctx, from, (NamedRef)toBranch, toHead);
        List<CommitLogEntry> toEntriesReverseChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, toHead), e -> e.getHash().equals((Object)commonAncestor)).collect(Collectors.toList());
        Collections.reverse(toEntriesReverseChronological);
        List<CommitLogEntry> commitsToMergeChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, from), e -> e.getHash().equals((Object)commonAncestor)).collect(Collectors.toList());
        if (commitsToMergeChronological.isEmpty()) {
            throw new IllegalArgumentException(String.format("No hashes to merge from '%s' onto '%s' @ '%s'.", from.asString(), toBranch.getName(), toHead));
        }
        Set<Key> keysTouchedOnTarget = this.collectModifiedKeys(toEntriesReverseChronological);
        this.checkForKeyCollisions(keysTouchedOnTarget, commitsToMergeChronological);
        toHead = this.copyCommits(ctx, timeInMicros, toHead, commitsToMergeChronological, newKeyLists);
        commitsToMergeChronological.stream().map(CommitLogEntry::getHash).forEach(branchCommits);
        this.writeMultipleCommits(ctx, commitsToMergeChronological);
        return toHead;
    }

    protected Hash transplantAttempt(OP_CONTEXT ctx, long timeInMicros, BranchName targetBranch, Optional<Hash> expectedHead, Hash targetHead, List<Hash> sequenceToTransplant, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException, ReferenceConflictException {
        if (sequenceToTransplant.isEmpty()) {
            throw new IllegalArgumentException("No hashes to transplant given.");
        }
        ArrayList<CommitLogEntry> targetEntriesReverseChronological = new ArrayList<CommitLogEntry>();
        this.hashOnRef(ctx, targetHead, (NamedRef)targetBranch, expectedHead, targetEntriesReverseChronological::add);
        if (!targetEntriesReverseChronological.isEmpty() && expectedHead.isPresent() && ((CommitLogEntry)targetEntriesReverseChronological.get(0)).getHash().equals((Object)expectedHead.get())) {
            targetEntriesReverseChronological.remove(0);
        }
        Collections.reverse(targetEntriesReverseChronological);
        Set<Key> keysTouchedOnTarget = this.collectModifiedKeys(targetEntriesReverseChronological);
        int[] index = new int[]{sequenceToTransplant.size() - 1};
        Hash lastHash = sequenceToTransplant.get(sequenceToTransplant.size() - 1);
        List<CommitLogEntry> commitsToTransplantChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, lastHash), e -> {
            int n = index[0];
            index[0] = n - 1;
            int i = n;
            if (i == -1) {
                return true;
            }
            if (!e.getHash().equals(sequenceToTransplant.get(i))) {
                throw new IllegalArgumentException("Sequence of hashes is not contiguous.");
            }
            return false;
        }).collect(Collectors.toList());
        this.checkForKeyCollisions(keysTouchedOnTarget, commitsToTransplantChronological);
        targetHead = this.copyCommits(ctx, timeInMicros, targetHead, commitsToTransplantChronological, newKeyLists);
        commitsToTransplantChronological.stream().map(CommitLogEntry::getHash).forEach(branchCommits);
        this.writeMultipleCommits(ctx, commitsToTransplantChronological);
        return targetHead;
    }

    protected Stream<Difference> buildDiff(OP_CONTEXT ctx, Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet allKeys = new HashSet();
        try (Stream<Key> s = this.keysForCommitEntry(ctx, from, keyFilter).map(KeyWithType::getKey);){
            s.forEach(allKeys::add);
        }
        s = this.keysForCommitEntry(ctx, to, keyFilter).map(KeyWithType::getKey);
        try {
            s.forEach(allKeys::add);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        if (allKeys.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<Key> allKeysList = new ArrayList<Key>(allKeys);
        Map<Key, ContentsAndState<ByteString>> fromValues = this.fetchValues(ctx, from, allKeysList, keyFilter);
        Map<Key, ContentsAndState<ByteString>> toValues = this.fetchValues(ctx, to, allKeysList, keyFilter);
        Function<ContentsAndState, Optional> valToContents = cs -> cs != null ? Optional.of((ByteString)cs.getRefState()) : Optional.empty();
        return IntStream.range(0, allKeys.size()).mapToObj(allKeysList::get).map(k -> {
            Optional t;
            ContentsAndState fromVal = (ContentsAndState)fromValues.get(k);
            ContentsAndState toVal = (ContentsAndState)toValues.get(k);
            Optional f = (Optional)valToContents.apply(fromVal);
            if (f.equals(t = (Optional)valToContents.apply(toVal))) {
                return null;
            }
            Optional<ByteString> g = Optional.ofNullable(fromVal != null ? (ByteString)fromVal.getGlobalState() : (toVal != null ? (ByteString)toVal.getGlobalState() : null));
            return Difference.of(k, g, f, t);
        }).filter(Objects::nonNull);
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, NamedRef reference, Optional<Hash> hashOnRef, Hash knownHead) throws ReferenceNotFoundException {
        return this.hashOnRef(ctx, knownHead, reference, hashOnRef, null);
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, Hash knownHead, NamedRef ref, Optional<Hash> hashOnRef, Consumer<CommitLogEntry> commitLogVisitor) throws ReferenceNotFoundException {
        if (hashOnRef.isPresent()) {
            Hash suspect = hashOnRef.get();
            if (suspect.equals((Object)NO_ANCESTOR)) {
                if (commitLogVisitor != null) {
                    this.readCommitLogStream(ctx, knownHead).forEach(commitLogVisitor);
                }
                return suspect;
            }
            Stream<Hash> hashes = commitLogVisitor != null ? this.readCommitLogStream(ctx, knownHead).peek(commitLogVisitor).map(CommitLogEntry::getHash) : this.readCommitLogHashesStream(ctx, knownHead);
            if (hashes.noneMatch(arg_0 -> ((Hash)suspect).equals(arg_0))) {
                throw DatabaseAdapterUtil.hashNotFound(ref, suspect);
            }
            return suspect;
        }
        return knownHead;
    }

    protected void validateHashExists(OP_CONTEXT ctx, Hash hash) throws ReferenceNotFoundException {
        if (!NO_ANCESTOR.equals((Object)hash) && this.fetchFromCommitLog(ctx, hash) == null) {
            throw DatabaseAdapterUtil.referenceNotFound(hash);
        }
    }

    protected abstract CommitLogEntry fetchFromCommitLog(OP_CONTEXT var1, Hash var2);

    protected abstract List<CommitLogEntry> fetchPageFromCommitLog(OP_CONTEXT var1, List<Hash> var2);

    protected Stream<CommitLogEntry> readCommitLogStream(OP_CONTEXT ctx, Hash initialHash) throws ReferenceNotFoundException {
        if (NO_ANCESTOR.equals((Object)initialHash)) {
            return Stream.empty();
        }
        CommitLogEntry initial = this.fetchFromCommitLog(ctx, initialHash);
        if (initial == null) {
            throw DatabaseAdapterUtil.referenceNotFound(initialHash);
        }
        return this.logFetcher(ctx, initial, this::fetchPageFromCommitLog, CommitLogEntry::getParents);
    }

    private Stream<Hash> readCommitLogHashesStream(OP_CONTEXT ctx, Hash initialHash) {
        return this.logFetcher(ctx, initialHash, (c, hashes) -> hashes, hash -> {
            CommitLogEntry entry = this.fetchFromCommitLog(ctx, (Hash)hash);
            if (entry == null) {
                return Collections.emptyList();
            }
            return entry.getParents();
        });
    }

    protected <T> Stream<T> logFetcher(final OP_CONTEXT ctx, final T initial, final BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, final Function<T, List<Hash>> nextPage) {
        Spliterators.AbstractSpliterator split = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            private Iterator<T> currentBatch;
            private boolean eof;
            private T previous;

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.eof) {
                    return false;
                }
                if (this.currentBatch == null) {
                    this.currentBatch = Collections.singletonList(initial).iterator();
                } else if (!this.currentBatch.hasNext()) {
                    if (this.previous == null) {
                        this.eof = true;
                        return false;
                    }
                    List page = (List)nextPage.apply(this.previous);
                    this.previous = null;
                    if (!page.isEmpty()) {
                        this.currentBatch = ((List)fetcher.apply(ctx, page)).iterator();
                    } else {
                        this.eof = true;
                        return false;
                    }
                }
                Object v = this.currentBatch.next();
                if (v != null) {
                    consumer.accept(v);
                    this.previous = v;
                }
                return true;
            }
        };
        return StreamSupport.stream(split, false);
    }

    protected CommitLogEntry buildIndividualCommit(OP_CONTEXT ctx, long timeInMicros, List<Hash> parentHashes, ByteString commitMeta, List<KeyWithBytes> puts, List<Key> deletes, int currentKeyListDistance, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException {
        Hash commitHash = this.individualCommitHash(parentHashes, commitMeta, puts, deletes);
        int keyListDistance = currentKeyListDistance + 1;
        CommitLogEntry entry = CommitLogEntry.of(timeInMicros, commitHash, parentHashes, commitMeta, puts, deletes, keyListDistance, null, Collections.emptyList());
        if (keyListDistance >= this.config.getKeyListDistance()) {
            entry = this.buildKeyList(ctx, entry, newKeyLists);
        }
        return entry;
    }

    protected Hash individualCommitHash(List<Hash> parentHashes, ByteString commitMeta, List<KeyWithBytes> puts, List<Key> deletes) {
        Hasher hasher = DatabaseAdapterUtil.newHasher();
        hasher.putLong(COMMIT_LOG_HASH_SEED);
        parentHashes.forEach(h -> hasher.putBytes(h.asBytes().asReadOnlyByteBuffer()));
        hasher.putBytes(commitMeta.asReadOnlyByteBuffer());
        puts.forEach(e -> {
            DatabaseAdapterUtil.hashKey(hasher, e.getKey());
            hasher.putString((CharSequence)e.getContentsId().getId(), StandardCharsets.UTF_8);
            hasher.putBytes(e.getValue().asReadOnlyByteBuffer());
        });
        deletes.forEach(e -> DatabaseAdapterUtil.hashKey(hasher, e));
        return Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])hasher.hash().asBytes()));
    }

    protected CommitLogEntry buildKeyList(OP_CONTEXT ctx, CommitLogEntry unwrittenEntry, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException {
        Hash startHash = unwrittenEntry.getParents().get(0);
        ImmutableCommitLogEntry.Builder newCommitEntry = ImmutableCommitLogEntry.builder().from(unwrittenEntry).keyListDistance(0);
        KeyListBuildState buildState = new KeyListBuildState(this.entitySize(unwrittenEntry), newCommitEntry);
        this.keysForCommitEntry(ctx, startHash).forEach(keyWithType -> {
            int keyTypeSize = this.entitySize((KeyWithType)keyWithType);
            if (buildState.embedded) {
                if (buildState.currentSize + keyTypeSize < this.config.getMaxKeyListSize()) {
                    buildState.addToEmbedded((KeyWithType)keyWithType, keyTypeSize);
                } else {
                    buildState.embedded = false;
                    buildState.newKeyListEntity();
                    buildState.addToKeyListEntity((KeyWithType)keyWithType, keyTypeSize);
                }
            } else {
                if (buildState.currentSize + keyTypeSize > this.config.getMaxKeyListSize()) {
                    buildState.finishKeyListEntity();
                    buildState.newKeyListEntity();
                }
                buildState.addToKeyListEntity((KeyWithType)keyWithType, keyTypeSize);
            }
        });
        if (buildState.currentKeyList != null) {
            buildState.finishKeyListEntity();
        }
        buildState.newKeyListEntities.stream().map(KeyListEntity::getId).forEach(newKeyLists);
        if (!buildState.newKeyListEntities.isEmpty()) {
            this.writeKeyListEntities(ctx, buildState.newKeyListEntities);
        }
        return newCommitEntry.keyList(buildState.embeddedBuilder.build()).build();
    }

    protected abstract int entitySize(CommitLogEntry var1);

    protected abstract int entitySize(KeyWithType var1);

    protected void checkForModifiedKeysBetweenExpectedAndCurrentCommit(OP_CONTEXT ctx, CommitAttempt commitAttempt, Hash branchHead, List<String> mismatches) throws ReferenceNotFoundException {
        Hash expectedHead;
        if (commitAttempt.getExpectedHead().isPresent() && !(expectedHead = commitAttempt.getExpectedHead().get()).equals((Object)branchHead)) {
            HashSet<Key> operationKeys = new HashSet<Key>();
            operationKeys.addAll(commitAttempt.getDeletes());
            operationKeys.addAll(commitAttempt.getUnchanged());
            commitAttempt.getPuts().stream().map(KeyWithBytes::getKey).forEach(operationKeys::add);
            boolean sinceSeen = this.checkConflictingKeysForCommit(ctx, branchHead, expectedHead, operationKeys, mismatches::add);
            if (!sinceSeen && !expectedHead.equals((Object)NO_ANCESTOR)) {
                throw DatabaseAdapterUtil.hashNotFound((NamedRef)commitAttempt.getCommitToBranch(), expectedHead);
            }
        }
    }

    protected Stream<KeyWithType> keysForCommitEntry(OP_CONTEXT ctx, Hash hash, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.keysForCommitEntry(ctx, hash).filter(kt -> keyFilter.check(kt.getKey(), kt.getContentsId(), kt.getType()));
    }

    protected Stream<KeyWithType> keysForCommitEntry(OP_CONTEXT ctx, Hash hash) throws ReferenceNotFoundException {
        HashSet seen = new HashSet();
        Stream<CommitLogEntry> log = this.readCommitLogStream(ctx, hash);
        log = DatabaseAdapterUtil.takeUntilIncludeLast(log, e -> e.getKeyList() != null);
        return log.flatMap(e -> {
            seen.addAll(e.getDeletes());
            Stream<KeyWithType> stream = e.getPuts().stream().filter(kt -> seen.add(kt.getKey())).map(KeyWithBytes::asKeyWithType);
            if (e.getKeyList() != null) {
                Stream<KeyWithType> embedded = e.getKeyList().getKeys().stream().filter(kt -> seen.add(kt.getKey()));
                stream = Stream.concat(stream, embedded);
                if (!e.getKeyListsIds().isEmpty()) {
                    stream = Stream.concat(stream, Stream.of(e.getKeyListsIds()).flatMap(ids -> this.fetchKeyLists(ctx, (List<Hash>)ids)).map(KeyListEntity::getKeys).flatMap(k -> k.getKeys().stream()).filter(kt -> seen.add(kt.getKey())));
                }
            }
            return stream;
        });
    }

    protected Map<Key, ContentsAndState<ByteString>> fetchValues(OP_CONTEXT ctx, Hash refHead, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet<Key> remainingKeys = new HashSet<Key>(keys);
        HashMap nonGlobal = new HashMap();
        HashMap keyToContentsIds = new HashMap();
        HashSet<ContentsId> contentsIds = new HashSet<ContentsId>();
        try (Stream<CommitLogEntry> log = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, refHead), e -> remainingKeys.isEmpty());){
            log.peek(entry -> entry.getDeletes().forEach(remainingKeys::remove)).flatMap(entry -> entry.getPuts().stream()).filter(put -> remainingKeys.remove(put.getKey())).filter(put -> keyFilter.check(put.getKey(), put.getContentsId(), put.getType())).forEach(put -> {
                nonGlobal.put(put.getKey(), put.getValue());
                keyToContentsIds.put(put.getKey(), put.getContentsId());
                contentsIds.add(put.getContentsId());
            });
        }
        Map<ContentsId, ByteString> globals = this.fetchGlobalStates(ctx, contentsIds);
        return nonGlobal.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ContentsAndState.of((ByteString)e.getValue(), (ByteString)globals.get(keyToContentsIds.get(e.getKey())))));
    }

    protected abstract Map<ContentsId, ByteString> fetchGlobalStates(OP_CONTEXT var1, Set<ContentsId> var2) throws ReferenceNotFoundException;

    protected abstract Stream<KeyListEntity> fetchKeyLists(OP_CONTEXT var1, List<Hash> var2);

    protected abstract void writeIndividualCommit(OP_CONTEXT var1, CommitLogEntry var2) throws ReferenceConflictException;

    protected abstract void writeMultipleCommits(OP_CONTEXT var1, List<CommitLogEntry> var2) throws ReferenceConflictException;

    protected abstract void writeKeyListEntities(OP_CONTEXT var1, List<KeyListEntity> var2);

    protected boolean checkConflictingKeysForCommit(OP_CONTEXT ctx, Hash upToCommitIncluding, Hash sinceCommitExcluding, Set<Key> keys, Consumer<String> mismatches) throws ReferenceNotFoundException {
        boolean[] sinceSeen = new boolean[1];
        Stream<CommitLogEntry> log = this.readCommitLogStream(ctx, upToCommitIncluding);
        log = DatabaseAdapterUtil.takeUntilExcludeLast(log, e -> {
            if (e.getHash().equals((Object)sinceCommitExcluding)) {
                sinceSeen[0] = true;
                return true;
            }
            return false;
        });
        HashSet handled = new HashSet();
        log.forEach(e -> {
            e.getPuts().forEach(a -> {
                if (keys.contains(a.getKey()) && handled.add(a.getKey())) {
                    mismatches.accept(String.format("Key '%s' has conflicting put-operation from another commit.", a.getKey()));
                }
            });
            e.getDeletes().forEach(a -> {
                if (keys.contains(a) && handled.add(a)) {
                    mismatches.accept(String.format("Key '%s' has conflicting delete-operation from another commit.", a));
                }
            });
        });
        return sinceSeen[0];
    }

    protected Hash findCommonAncestor(OP_CONTEXT ctx, Hash from, NamedRef toBranch, Hash toHead) throws ReferenceConflictException {
        Hash f;
        Iterator toLog = Spliterators.iterator(this.readCommitLogHashesStream(ctx, toHead).spliterator());
        Iterator fromLog = Spliterators.iterator(this.readCommitLogHashesStream(ctx, from).spliterator());
        HashSet<Hash> toCommitHashes = new HashSet<Hash>();
        ArrayList<Hash> fromCommitHashes = new ArrayList<Hash>();
        block0: while (true) {
            boolean anyFetched = false;
            for (int i = 0; i < this.config.getParentsPerCommit(); ++i) {
                if (toLog.hasNext()) {
                    toCommitHashes.add((Hash)toLog.next());
                    anyFetched = true;
                }
                if (!fromLog.hasNext()) continue;
                fromCommitHashes.add((Hash)fromLog.next());
                anyFetched = true;
            }
            if (!anyFetched) {
                throw new ReferenceConflictException(String.format("No common ancestor found for merge of '%s' into branch '%s'", from, toBranch.getName()));
            }
            Iterator iterator = fromCommitHashes.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!toCommitHashes.contains(f = (Hash)iterator.next()));
            break;
        }
        return f;
    }

    protected void checkForKeyCollisions(Set<Key> keysTouchedOnTarget, List<CommitLogEntry> commitsChronological) throws ReferenceConflictException {
        HashSet keyCollisions = new HashSet();
        for (int i = commitsChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            Stream.concat(sourceCommit.getPuts().stream().map(KeyWithBytes::getKey), sourceCommit.getDeletes().stream()).filter(keysTouchedOnTarget::contains).forEach(keyCollisions::add);
        }
        if (!keyCollisions.isEmpty()) {
            throw new ReferenceConflictException(String.format("The following keys have been changed in conflict: %s", keyCollisions.stream().map(k -> String.format("'%s'", k.toString())).collect(Collectors.joining(", "))));
        }
    }

    protected Set<Key> collectModifiedKeys(List<CommitLogEntry> commitsReverseChronological) {
        HashSet<Key> keysTouchedOnTarget = new HashSet<Key>();
        commitsReverseChronological.forEach(e -> {
            e.getPuts().stream().map(KeyWithBytes::getKey).forEach(keysTouchedOnTarget::add);
            e.getDeletes().forEach(keysTouchedOnTarget::remove);
        });
        return keysTouchedOnTarget;
    }

    protected Hash copyCommits(OP_CONTEXT ctx, long timeInMicros, Hash targetHead, List<CommitLogEntry> commitsChronological, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException {
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> parents = new ArrayList<Hash>(parentsPerCommit);
        CommitLogEntry targetHeadCommit = this.fetchFromCommitLog(ctx, targetHead);
        if (targetHeadCommit != null) {
            parents.addAll(targetHeadCommit.getParents());
        }
        int keyListDistance = targetHeadCommit != null ? targetHeadCommit.getKeyListDistance() : 0;
        for (int i = commitsChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            while (parents.size() > parentsPerCommit - 1) {
                parents.remove(parentsPerCommit - 1);
            }
            if (parents.isEmpty()) {
                parents.add(targetHead);
            } else {
                parents.add(0, targetHead);
            }
            CommitLogEntry newEntry = this.buildIndividualCommit(ctx, timeInMicros, parents, sourceCommit.getMetadata(), sourceCommit.getPuts(), sourceCommit.getDeletes(), keyListDistance, newKeyLists);
            keyListDistance = newEntry.getKeyListDistance();
            if (!newEntry.getHash().equals((Object)sourceCommit.getHash())) {
                commitsChronological.set(i, newEntry);
            } else {
                commitsChronological.remove(i);
            }
            targetHead = newEntry.getHash();
        }
        return targetHead;
    }

    protected void checkExpectedGlobalStates(OP_CONTEXT ctx, CommitAttempt commitAttempt, Consumer<String> mismatches) throws ReferenceNotFoundException {
        Map<ContentsId, ByteString> globalStates = this.fetchGlobalStates(ctx, commitAttempt.getExpectedStates().keySet());
        for (Map.Entry<ContentsId, Optional<ByteString>> expectedState : commitAttempt.getExpectedStates().entrySet()) {
            ByteString currentState = globalStates.get(expectedState.getKey());
            if (currentState == null) {
                if (!expectedState.getValue().isPresent()) continue;
                mismatches.accept(String.format("No current global-state for contents-id '%s'.", expectedState.getKey()));
                continue;
            }
            if (!expectedState.getValue().isPresent()) {
                mismatches.accept(String.format("Global-state for contents-id '%s' already exists.", expectedState.getKey()));
                continue;
            }
            if (currentState.equals((Object)expectedState.getValue().get())) continue;
            mismatches.accept(String.format("Mismatch in global-state for contents-id '%s'.", expectedState.getKey()));
        }
    }

    private static class KeyListBuildState {
        final ImmutableCommitLogEntry.Builder newCommitEntry;
        ImmutableKeyList.Builder embeddedBuilder = ImmutableKeyList.builder();
        ImmutableKeyList.Builder currentKeyList;
        List<KeyListEntity> newKeyListEntities = new ArrayList<KeyListEntity>();
        boolean embedded = true;
        int currentSize;

        KeyListBuildState(int initialSize, ImmutableCommitLogEntry.Builder newCommitEntry) {
            this.currentSize = initialSize;
            this.newCommitEntry = newCommitEntry;
        }

        void finishKeyListEntity() {
            Hash id = DatabaseAdapterUtil.randomHash();
            this.newKeyListEntities.add(KeyListEntity.of(id, this.currentKeyList.build()));
            this.newCommitEntry.addKeyListsIds(id);
        }

        void newKeyListEntity() {
            this.currentSize = 0;
            this.currentKeyList = ImmutableKeyList.builder();
        }

        void addToKeyListEntity(KeyWithType keyWithType, int keyTypeSize) {
            this.currentSize += keyTypeSize;
            this.currentKeyList.addKeys(keyWithType);
        }

        void addToEmbedded(KeyWithType keyWithType, int keyTypeSize) {
            this.currentSize += keyTypeSize;
            this.embeddedBuilder.addKeys(keyWithType);
        }
    }
}

