/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ContentsId;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyWithBytes", generator="Immutables")
@Immutable
public final class ImmutableKeyWithBytes
implements KeyWithBytes {
    private final Key key;
    private final ContentsId contentsId;
    private final byte type;
    private final ByteString value;

    private ImmutableKeyWithBytes(Key key, ContentsId contentsId, byte type, ByteString value) {
        this.key = key;
        this.contentsId = contentsId;
        this.type = type;
        this.value = value;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public ContentsId getContentsId() {
        return this.contentsId;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public ByteString getValue() {
        return this.value;
    }

    public final ImmutableKeyWithBytes withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyWithBytes(newValue, this.contentsId, this.type, this.value);
    }

    public final ImmutableKeyWithBytes withContentsId(ContentsId value) {
        if (this.contentsId == value) {
            return this;
        }
        ContentsId newValue = Objects.requireNonNull(value, "contentsId");
        return new ImmutableKeyWithBytes(this.key, newValue, this.type, this.value);
    }

    public final ImmutableKeyWithBytes withType(byte value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableKeyWithBytes(this.key, this.contentsId, value, this.value);
    }

    public final ImmutableKeyWithBytes withValue(ByteString value) {
        if (this.value == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "value");
        return new ImmutableKeyWithBytes(this.key, this.contentsId, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyWithBytes && this.equalTo((ImmutableKeyWithBytes)another);
    }

    private boolean equalTo(ImmutableKeyWithBytes another) {
        return this.key.equals((Object)another.key) && this.contentsId.equals(another.contentsId) && this.type == another.type && this.value.equals((Object)another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contentsId.hashCode();
        h += (h << 5) + Bytes.hashCode((byte)this.type);
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyWithBytes").omitNullValues().add("key", (Object)this.key).add("contentsId", (Object)this.contentsId).add("type", (int)this.type).add("value", (Object)this.value).toString();
    }

    public static ImmutableKeyWithBytes copyOf(KeyWithBytes instance) {
        if (instance instanceof ImmutableKeyWithBytes) {
            return (ImmutableKeyWithBytes)instance;
        }
        return ImmutableKeyWithBytes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyWithBytes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENTS_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_VALUE = 8L;
        private long initBits = 15L;
        @Nullable
        private Key key;
        @Nullable
        private ContentsId contentsId;
        private byte type;
        @Nullable
        private ByteString value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyWithBytes instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contentsId(instance.getContentsId());
            this.type(instance.getType());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentsId(ContentsId contentsId) {
            this.contentsId = Objects.requireNonNull(contentsId, "contentsId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(byte type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ByteString value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableKeyWithBytes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyWithBytes(this.key, this.contentsId, this.type, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentsId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build KeyWithBytes, some of required attributes are not set " + attributes;
        }
    }
}

