/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;

class TestTryLoopState {
    TestTryLoopState() {
    }

    @ParameterizedTest
    @ValueSource(ints={1, 5, 50})
    void retriesWithinBounds(int retries) throws Exception {
        Object[] times = new Long[retries];
        Arrays.fill(times, (Object)0L);
        TryLoopState.MonotonicClock clock = this.mockedClock(0L, (Long[])times);
        TryLoopState tryLoopState = new TryLoopState(this::retryErrorMessage, this.mockedConfig(retries, 42L), clock);
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)1))).currentNanos();
        for (int i = 0; i < retries; ++i) {
            tryLoopState.retry();
        }
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)(1 + retries)))).currentNanos();
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)retries))).sleepMillis(ArgumentMatchers.anyLong());
    }

    @ParameterizedTest
    @ValueSource(ints={1, 5, 50})
    void retriesOutOfBounds(int retries) throws Exception {
        Object[] times = new Long[retries];
        Arrays.fill(times, (Object)0L);
        TryLoopState.MonotonicClock clock = this.mockedClock(0L, (Long[])times);
        TryLoopState tryLoopState = new TryLoopState(this::retryErrorMessage, this.mockedConfig(retries - 1, 42L), clock);
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)1))).currentNanos();
        for (int i = 0; i < retries - 1; ++i) {
            tryLoopState.retry();
        }
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)retries))).currentNanos();
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)(retries - 1)))).sleepMillis(ArgumentMatchers.anyLong());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TryLoopState)tryLoopState).retry()).isInstanceOf(ReferenceRetryFailureException.class)).hasMessage(this.retryErrorMessage());
    }

    @Test
    void sleepDurations() throws Exception {
        int retries = 10;
        Object[] times = new Long[retries];
        Arrays.fill(times, (Object)0L);
        TryLoopState.MonotonicClock clock = this.mockedClock(0L, (Long[])times);
        long timeoutMillis = 42L;
        TryLoopState tryLoopState = new TryLoopState(this::retryErrorMessage, this.mockedConfig(retries, timeoutMillis), clock);
        long lower = 5L;
        long upper = 25L;
        for (int i = 0; i < retries; ++i) {
            tryLoopState.retry();
            long l = Math.min(lower, timeoutMillis);
            long u = Math.min(upper, timeoutMillis);
            ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock)).sleepMillis(ArgumentMatchers.longThat(v -> v >= l && v <= u));
            Mockito.clearInvocations((Object[])new TryLoopState.MonotonicClock[]{clock});
            lower *= 2L;
            upper *= 2L;
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 5, 50})
    void retriesOutOfTime(int retries) throws Exception {
        Object[] times = new Long[retries];
        Arrays.fill(times, (Object)0L);
        times[retries - 1] = TimeUnit.MILLISECONDS.toNanos(43L);
        TryLoopState.MonotonicClock clock = this.mockedClock(0L, (Long[])times);
        TryLoopState tryLoopState = new TryLoopState(this::retryErrorMessage, this.mockedConfig(retries, 42L), clock);
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)1))).currentNanos();
        for (int i = 0; i < retries - 1; ++i) {
            tryLoopState.retry();
        }
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)retries))).currentNanos();
        ((TryLoopState.MonotonicClock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)(retries - 1)))).sleepMillis(ArgumentMatchers.anyLong());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TryLoopState)tryLoopState).retry()).isInstanceOf(ReferenceRetryFailureException.class)).hasMessage(this.retryErrorMessage());
    }

    TryLoopState.MonotonicClock mockedClock(Long t0, Long ... times) {
        TryLoopState.MonotonicClock mock = (TryLoopState.MonotonicClock)Mockito.spy(TryLoopState.MonotonicClock.class);
        Mockito.when((Object)mock.currentNanos()).thenReturn((Object)t0, (Object[])times);
        ((TryLoopState.MonotonicClock)Mockito.doNothing().when((Object)mock)).sleepMillis(ArgumentMatchers.anyLong());
        return mock;
    }

    DatabaseAdapterConfig mockedConfig(int commitRetries, long commitTImeout) {
        DatabaseAdapterConfig mock = (DatabaseAdapterConfig)Mockito.mock(DatabaseAdapterConfig.class);
        Mockito.when((Object)mock.getCommitRetries()).thenReturn((Object)commitRetries);
        Mockito.when((Object)mock.getCommitTimeout()).thenReturn((Object)commitTImeout);
        return mock;
    }

    private String retryErrorMessage() {
        return "RETRY ERROR MESSAGE";
    }
}

