package org.projectnessie.versioned.persist.adapter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentsId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsId.builder()}.
 */
@Generated(from = "ContentsId", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsId extends ContentsId {
  private final String id;

  private ImmutableContentsId(String id) {
    this.id = id;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsId#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsId withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableContentsId(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsId
        && equalTo((ImmutableContentsId) another);
  }

  private boolean equalTo(ImmutableContentsId another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link ContentsId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentsId instance
   */
  public static ImmutableContentsId copyOf(ContentsId instance) {
    if (instance instanceof ImmutableContentsId) {
      return (ImmutableContentsId) instance;
    }
    return ImmutableContentsId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsId ImmutableContentsId}.
   * <pre>
   * ImmutableContentsId.builder()
   *    .id(String) // required {@link ContentsId#getId() id}
   *    .build();
   * </pre>
   * @return A new ImmutableContentsId builder
   */
  public static ImmutableContentsId.Builder builder() {
    return new ImmutableContentsId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentsId ImmutableContentsId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentsId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentsId instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsId#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsId ImmutableContentsId}.
     * @return An immutable instance of ContentsId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentsId(id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ContentsId, some of required attributes are not set " + attributes;
    }
  }
}
