package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentsAndState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsAndState.builder()}.
 */
@Generated(from = "ContentsAndState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsAndState<CONTENTS>
    implements ContentsAndState<CONTENTS> {
  private final CONTENTS refState;
  private final @Nullable CONTENTS globalState;

  private ImmutableContentsAndState(CONTENTS refState, @Nullable CONTENTS globalState) {
    this.refState = refState;
    this.globalState = globalState;
  }

  /**
   *Per-named-reference state for a contents key. For example, Iceberg's snapshot-ID. 
   */
  @Override
  public CONTENTS getRefState() {
    return refState;
  }

  /**
   *Global state for a contents key. For example, the pointer to Iceberg's table-metadata. 
   */
  @Override
  public @Nullable CONTENTS getGlobalState() {
    return globalState;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsAndState#getRefState() refState} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refState
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsAndState<CONTENTS> withRefState(CONTENTS value) {
    if (this.refState == value) return this;
    CONTENTS newValue = Objects.requireNonNull(value, "refState");
    return new ImmutableContentsAndState<>(newValue, this.globalState);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsAndState#getGlobalState() globalState} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for globalState (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsAndState<CONTENTS> withGlobalState(@Nullable CONTENTS value) {
    if (this.globalState == value) return this;
    return new ImmutableContentsAndState<>(this.refState, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsAndState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsAndState<?>
        && equalTo((ImmutableContentsAndState<?>) another);
  }

  private boolean equalTo(ImmutableContentsAndState<?> another) {
    return refState.equals(another.refState)
        && Objects.equals(globalState, another.globalState);
  }

  /**
   * Computes a hash code from attributes: {@code refState}, {@code globalState}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + refState.hashCode();
    h += (h << 5) + Objects.hashCode(globalState);
    return h;
  }

  /**
   * Prints the immutable value {@code ContentsAndState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ContentsAndState")
        .omitNullValues()
        .add("refState", refState)
        .add("globalState", globalState)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ContentsAndState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <CONTENTS> generic parameter CONTENTS
   * @param instance The instance to copy
   * @return A copied immutable ContentsAndState instance
   */
  public static <CONTENTS> ImmutableContentsAndState<CONTENTS> copyOf(ContentsAndState<CONTENTS> instance) {
    if (instance instanceof ImmutableContentsAndState<?>) {
      return (ImmutableContentsAndState<CONTENTS>) instance;
    }
    return ImmutableContentsAndState.<CONTENTS>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsAndState ImmutableContentsAndState}.
   * <pre>
   * ImmutableContentsAndState.&amp;lt;CONTENTS&amp;gt;builder()
   *    .refState(CONTENTS) // required {@link ContentsAndState#getRefState() refState}
   *    .globalState(CONTENTS | null) // nullable {@link ContentsAndState#getGlobalState() globalState}
   *    .build();
   * </pre>
   * @param <CONTENTS> generic parameter CONTENTS
   * @return A new ImmutableContentsAndState builder
   */
  public static <CONTENTS> ImmutableContentsAndState.Builder<CONTENTS> builder() {
    return new ImmutableContentsAndState.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableContentsAndState ImmutableContentsAndState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentsAndState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<CONTENTS> {
    private static final long INIT_BIT_REF_STATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable CONTENTS refState;
    private @Nullable CONTENTS globalState;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsAndState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<CONTENTS> from(ContentsAndState<CONTENTS> instance) {
      Objects.requireNonNull(instance, "instance");
      refState(instance.getRefState());
      @Nullable CONTENTS globalStateValue = instance.getGlobalState();
      if (globalStateValue != null) {
        globalState(globalStateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsAndState#getRefState() refState} attribute.
     * @param refState The value for refState 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<CONTENTS> refState(CONTENTS refState) {
      this.refState = Objects.requireNonNull(refState, "refState");
      initBits &= ~INIT_BIT_REF_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsAndState#getGlobalState() globalState} attribute.
     * @param globalState The value for globalState (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<CONTENTS> globalState(@Nullable CONTENTS globalState) {
      this.globalState = globalState;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsAndState ImmutableContentsAndState}.
     * @return An immutable instance of ContentsAndState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsAndState<CONTENTS> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentsAndState<>(refState, globalState);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REF_STATE) != 0) attributes.add("refState");
      return "Cannot build ContentsAndState, some of required attributes are not set " + attributes;
    }
  }
}
