/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import java.time.Clock;
import org.immutables.value.Value;

public interface DatabaseAdapterConfig {
    public static final String DEFAULT_KEY_PREFIX = "";
    public static final int DEFAULT_PARENTS_PER_COMMIT = 20;
    public static final int DEFAULT_KEY_LIST_DISTANCE = 20;
    public static final int DEFAULT_MAX_KEY_LIST_SIZE = 250000;
    public static final int DEFAULT_COMMIT_TIMEOUT = 500;
    public static final int DEFAULT_COMMIT_RETRIES = Integer.MAX_VALUE;

    @Value.Default
    default public String getKeyPrefix() {
        return DEFAULT_KEY_PREFIX;
    }

    @Value.Default
    default public int getParentsPerCommit() {
        return 20;
    }

    @Value.Default
    default public int getKeyListDistance() {
        return 20;
    }

    @Value.Default
    default public int getMaxKeyListSize() {
        return this.getDefaultMaxKeyListSize();
    }

    default public int getDefaultMaxKeyListSize() {
        return 250000;
    }

    @Value.Default
    default public long getCommitTimeout() {
        return 500L;
    }

    @Value.Default
    default public int getCommitRetries() {
        return Integer.MAX_VALUE;
    }

    @Value.Default
    default public Clock getClock() {
        return Clock.systemUTC();
    }
}

