package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;

/**
 * Immutable implementation of {@link KeyWithType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyWithType.builder()}.
 */
@Generated(from = "KeyWithType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyWithType implements KeyWithType {
  private final Key key;
  private final ContentsId contentsId;
  private final byte type;
  @SuppressWarnings("Immutable")
  private transient int hashCode; // hashCode lazily computed

  private ImmutableKeyWithType(
      Key key,
      ContentsId contentsId,
      byte type) {
    this.key = key;
    this.contentsId = contentsId;
    this.type = type;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public Key getKey() {
    return key;
  }

  /**
   * @return The value of the {@code contentsId} attribute
   */
  @Override
  public ContentsId getContentsId() {
    return contentsId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public byte getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithType#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithType withKey(Key value) {
    if (this.key == value) return this;
    Key newValue = Objects.requireNonNull(value, "key");
    return new ImmutableKeyWithType(newValue, this.contentsId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithType#getContentsId() contentsId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentsId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithType withContentsId(ContentsId value) {
    if (this.contentsId == value) return this;
    ContentsId newValue = Objects.requireNonNull(value, "contentsId");
    return new ImmutableKeyWithType(this.key, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithType#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithType withType(byte value) {
    if (this.type == value) return this;
    return new ImmutableKeyWithType(this.key, this.contentsId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyWithType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyWithType
        && equalTo((ImmutableKeyWithType) another);
  }

  private boolean equalTo(ImmutableKeyWithType another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return key.equals(another.key)
        && contentsId.equals(another.contentsId)
        && type == another.type;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code key}, {@code contentsId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + contentsId.hashCode();
    h += (h << 5) + Bytes.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code KeyWithType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KeyWithType")
        .omitNullValues()
        .add("key", key)
        .add("contentsId", contentsId)
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link KeyWithType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyWithType instance
   */
  public static ImmutableKeyWithType copyOf(KeyWithType instance) {
    if (instance instanceof ImmutableKeyWithType) {
      return (ImmutableKeyWithType) instance;
    }
    return ImmutableKeyWithType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyWithType ImmutableKeyWithType}.
   * <pre>
   * ImmutableKeyWithType.builder()
   *    .key(org.projectnessie.versioned.Key) // required {@link KeyWithType#getKey() key}
   *    .contentsId(org.projectnessie.versioned.persist.adapter.ContentsId) // required {@link KeyWithType#getContentsId() contentsId}
   *    .type(byte) // required {@link KeyWithType#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyWithType builder
   */
  public static ImmutableKeyWithType.Builder builder() {
    return new ImmutableKeyWithType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyWithType ImmutableKeyWithType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyWithType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENTS_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Key key;
    private @Nullable ContentsId contentsId;
    private byte type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyWithType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeyWithType instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      contentsId(instance.getContentsId());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithType#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(Key key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithType#getContentsId() contentsId} attribute.
     * @param contentsId The value for contentsId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentsId(ContentsId contentsId) {
      this.contentsId = Objects.requireNonNull(contentsId, "contentsId");
      initBits &= ~INIT_BIT_CONTENTS_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(byte type) {
      this.type = type;
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyWithType ImmutableKeyWithType}.
     * @return An immutable instance of KeyWithType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyWithType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeyWithType(key, contentsId, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENTS_ID) != 0) attributes.add("contentsId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build KeyWithType, some of required attributes are not set " + attributes;
    }
  }
}
