/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentsAndState;
import org.projectnessie.versioned.persist.adapter.ContentsId;
import org.projectnessie.versioned.persist.adapter.ContentsIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ContentsIdWithType;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithType;

public interface DatabaseAdapter {
    public void initializeRepo(String var1);

    public void reinitializeRepo(String var1);

    public Hash noAncestorHash();

    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException;

    public Hash toHash(NamedRef var1) throws ReferenceNotFoundException;

    public Stream<Optional<ContentsAndState<ByteString>>> values(Hash var1, List<Key> var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    public Stream<CommitLogEntry> commitLog(Hash var1) throws ReferenceNotFoundException;

    public Stream<KeyWithType> keys(Hash var1, KeyFilterPredicate var2) throws ReferenceNotFoundException;

    public Hash commit(CommitAttempt var1) throws ReferenceConflictException, ReferenceNotFoundException;

    public Hash transplant(BranchName var1, Optional<Hash> var2, List<Hash> var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Hash merge(Hash var1, BranchName var2, Optional<Hash> var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Stream<WithHash<NamedRef>> namedRefs();

    public Hash create(NamedRef var1, Hash var2) throws ReferenceAlreadyExistsException, ReferenceNotFoundException;

    public void delete(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public void assign(NamedRef var1, Optional<Hash> var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Stream<Difference> diff(Hash var1, Hash var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    public Stream<ContentsIdWithType> globalKeys(ToIntFunction<ByteString> var1);

    public Stream<ContentsIdAndBytes> globalContents(Set<ContentsId> var1, ToIntFunction<ByteString> var2);
}

