package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentsIdWithType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsIdWithType.builder()}.
 */
@Generated(from = "ContentsIdWithType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsIdWithType
    implements ContentsIdWithType {
  private final ContentsId contentsId;
  private final byte type;

  private ImmutableContentsIdWithType(ContentsId contentsId, byte type) {
    this.contentsId = contentsId;
    this.type = type;
  }

  /**
   * @return The value of the {@code contentsId} attribute
   */
  @Override
  public ContentsId getContentsId() {
    return contentsId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public byte getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsIdWithType#getContentsId() contentsId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentsId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsIdWithType withContentsId(ContentsId value) {
    if (this.contentsId == value) return this;
    ContentsId newValue = Objects.requireNonNull(value, "contentsId");
    return new ImmutableContentsIdWithType(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsIdWithType#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsIdWithType withType(byte value) {
    if (this.type == value) return this;
    return new ImmutableContentsIdWithType(this.contentsId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsIdWithType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsIdWithType
        && equalTo((ImmutableContentsIdWithType) another);
  }

  private boolean equalTo(ImmutableContentsIdWithType another) {
    return contentsId.equals(another.contentsId)
        && type == another.type;
  }

  /**
   * Computes a hash code from attributes: {@code contentsId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + contentsId.hashCode();
    h += (h << 5) + Bytes.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code ContentsIdWithType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ContentsIdWithType")
        .omitNullValues()
        .add("contentsId", contentsId)
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ContentsIdWithType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentsIdWithType instance
   */
  public static ImmutableContentsIdWithType copyOf(ContentsIdWithType instance) {
    if (instance instanceof ImmutableContentsIdWithType) {
      return (ImmutableContentsIdWithType) instance;
    }
    return ImmutableContentsIdWithType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsIdWithType ImmutableContentsIdWithType}.
   * <pre>
   * ImmutableContentsIdWithType.builder()
   *    .contentsId(org.projectnessie.versioned.persist.adapter.ContentsId) // required {@link ContentsIdWithType#getContentsId() contentsId}
   *    .type(byte) // required {@link ContentsIdWithType#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableContentsIdWithType builder
   */
  public static ImmutableContentsIdWithType.Builder builder() {
    return new ImmutableContentsIdWithType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentsIdWithType ImmutableContentsIdWithType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentsIdWithType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTENTS_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentsId contentsId;
    private byte type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsIdWithType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentsIdWithType instance) {
      Objects.requireNonNull(instance, "instance");
      contentsId(instance.getContentsId());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsIdWithType#getContentsId() contentsId} attribute.
     * @param contentsId The value for contentsId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentsId(ContentsId contentsId) {
      this.contentsId = Objects.requireNonNull(contentsId, "contentsId");
      initBits &= ~INIT_BIT_CONTENTS_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsIdWithType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(byte type) {
      this.type = type;
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsIdWithType ImmutableContentsIdWithType}.
     * @return An immutable instance of ContentsIdWithType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsIdWithType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentsIdWithType(contentsId, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENTS_ID) != 0) attributes.add("contentsId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ContentsIdWithType, some of required attributes are not set " + attributes;
    }
  }
}
