package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentsIdAndBytes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsIdAndBytes.builder()}.
 */
@Generated(from = "ContentsIdAndBytes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsIdAndBytes
    implements ContentsIdAndBytes {
  private final ContentsId contentsId;
  private final byte type;
  private final ByteString value;

  private ImmutableContentsIdAndBytes(
      ContentsId contentsId,
      byte type,
      ByteString value) {
    this.contentsId = contentsId;
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code contentsId} attribute
   */
  @Override
  public ContentsId getContentsId() {
    return contentsId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public byte getType() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public ByteString getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsIdAndBytes#getContentsId() contentsId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentsId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsIdAndBytes withContentsId(ContentsId value) {
    if (this.contentsId == value) return this;
    ContentsId newValue = Objects.requireNonNull(value, "contentsId");
    return new ImmutableContentsIdAndBytes(newValue, this.type, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsIdAndBytes#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsIdAndBytes withType(byte value) {
    if (this.type == value) return this;
    return new ImmutableContentsIdAndBytes(this.contentsId, value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentsIdAndBytes#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsIdAndBytes withValue(ByteString value) {
    if (this.value == value) return this;
    ByteString newValue = Objects.requireNonNull(value, "value");
    return new ImmutableContentsIdAndBytes(this.contentsId, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsIdAndBytes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsIdAndBytes
        && equalTo((ImmutableContentsIdAndBytes) another);
  }

  private boolean equalTo(ImmutableContentsIdAndBytes another) {
    return contentsId.equals(another.contentsId)
        && type == another.type
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code contentsId}, {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + contentsId.hashCode();
    h += (h << 5) + Bytes.hashCode(type);
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ContentsIdAndBytes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ContentsIdAndBytes")
        .omitNullValues()
        .add("contentsId", contentsId)
        .add("type", type)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ContentsIdAndBytes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentsIdAndBytes instance
   */
  public static ImmutableContentsIdAndBytes copyOf(ContentsIdAndBytes instance) {
    if (instance instanceof ImmutableContentsIdAndBytes) {
      return (ImmutableContentsIdAndBytes) instance;
    }
    return ImmutableContentsIdAndBytes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsIdAndBytes ImmutableContentsIdAndBytes}.
   * <pre>
   * ImmutableContentsIdAndBytes.builder()
   *    .contentsId(org.projectnessie.versioned.persist.adapter.ContentsId) // required {@link ContentsIdAndBytes#getContentsId() contentsId}
   *    .type(byte) // required {@link ContentsIdAndBytes#getType() type}
   *    .value(com.google.protobuf.ByteString) // required {@link ContentsIdAndBytes#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableContentsIdAndBytes builder
   */
  public static ImmutableContentsIdAndBytes.Builder builder() {
    return new ImmutableContentsIdAndBytes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentsIdAndBytes ImmutableContentsIdAndBytes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentsIdAndBytes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTENTS_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable ContentsId contentsId;
    private byte type;
    private @Nullable ByteString value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsIdAndBytes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentsIdAndBytes instance) {
      Objects.requireNonNull(instance, "instance");
      contentsId(instance.getContentsId());
      type(instance.getType());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsIdAndBytes#getContentsId() contentsId} attribute.
     * @param contentsId The value for contentsId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentsId(ContentsId contentsId) {
      this.contentsId = Objects.requireNonNull(contentsId, "contentsId");
      initBits &= ~INIT_BIT_CONTENTS_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsIdAndBytes#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(byte type) {
      this.type = type;
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContentsIdAndBytes#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(ByteString value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsIdAndBytes ImmutableContentsIdAndBytes}.
     * @return An immutable instance of ContentsIdAndBytes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsIdAndBytes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentsIdAndBytes(contentsId, type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENTS_ID) != 0) attributes.add("contentsId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ContentsIdAndBytes, some of required attributes are not set " + attributes;
    }
  }
}
