/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;

public final class DatabaseAdapterUtil {
    private DatabaseAdapterUtil() {
    }

    public static Hasher newHasher() {
        return Hashing.sha256().newHasher();
    }

    public static Hash randomHash() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        Hasher hasher = DatabaseAdapterUtil.newHasher();
        for (int i = 0; i < 20; ++i) {
            hasher.putInt(rand.nextInt());
        }
        return Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])hasher.hash().asBytes()));
    }

    public static void hashKey(Hasher hasher, Key k) {
        k.getElements().forEach(e -> hasher.putString((CharSequence)e, StandardCharsets.UTF_8));
    }

    public static ReferenceConflictException hashCollisionDetected() {
        return new ReferenceConflictException("Hash collision detected");
    }

    public static ReferenceNotFoundException hashNotFound(NamedRef ref, Hash hash) {
        return new ReferenceNotFoundException(String.format("Could not find commit '%s' in reference '%s'.", hash.asString(), ref.getName()));
    }

    public static ReferenceNotFoundException referenceNotFound(NamedRef ref) {
        return new ReferenceNotFoundException(String.format("Named reference '%s' not found", ref.getName()));
    }

    public static ReferenceNotFoundException referenceNotFound(Hash hash) {
        return new ReferenceNotFoundException(String.format("Commit '%s' not found", hash.asString()));
    }

    public static ReferenceAlreadyExistsException referenceAlreadyExists(NamedRef ref) {
        return new ReferenceAlreadyExistsException(String.format("Named reference '%s' already exists.", ref.getName()));
    }

    public static String mergeConflictMessage(String err, Hash from, BranchName toBranch, Optional<Hash> expectedHead) {
        return String.format("%s during merge of '%s' into '%s%s' requiring a common ancestor", err, from.asString(), toBranch.getName(), expectedHead.map(h -> "@" + h.asString()).orElse(""));
    }

    public static String transplantConflictMessage(String err, BranchName targetBranch, Optional<Hash> expectedHead, List<Hash> sequenceToTransplant) {
        return String.format("%s during transplant of %d commits into '%s%s'", err, sequenceToTransplant.size(), targetBranch.getName(), expectedHead.map(h -> "@" + h.asString()).orElse(""));
    }

    public static String commitConflictMessage(String err, BranchName commitTo, Optional<Hash> expectedHead) {
        return String.format("%s during commit against '%s%s'", err, commitTo.getName(), expectedHead.map(h -> "@" + h.asString()).orElse(""));
    }

    public static String createConflictMessage(String err, NamedRef ref, Hash target) {
        return String.format("%s during create of reference '%s' at '%s'", err, ref.getName(), target.asString());
    }

    public static String deleteConflictMessage(String err, NamedRef reference, Optional<Hash> expectedHead) {
        return String.format("%s during delete of reference '%s%s'", err, reference.getName(), expectedHead.map(h -> "@" + h.asString()).orElse(""));
    }

    public static String assignConflictMessage(String err, NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) {
        return String.format("%s during reassign of reference %s%s to '%s'", err, assignee.getName(), expectedHead.map(h -> "@" + h.asString()).orElse(""), assignTo.asString());
    }

    public static void verifyExpectedHash(Hash referenceCurrentHead, NamedRef reference, Optional<Hash> expectedHead) throws ReferenceConflictException {
        if (expectedHead.isPresent() && !referenceCurrentHead.equals((Object)expectedHead.get())) {
            throw new ReferenceConflictException(String.format("Named-reference '%s' is not at expected hash '%s', but at '%s'.", reference.getName(), expectedHead.get().asString(), referenceCurrentHead.asString()));
        }
    }

    public static <T> Stream<T> takeUntilExcludeLast(Stream<T> stream, Predicate<T> stopPredicate) {
        return DatabaseAdapterUtil.takeUntil(stream, stopPredicate, false);
    }

    public static <T> Stream<T> takeUntilIncludeLast(Stream<T> stream, Predicate<T> stopPredicate) {
        return DatabaseAdapterUtil.takeUntil(stream, stopPredicate, true);
    }

    private static <T> Stream<T> takeUntil(Stream<T> stream, final Predicate<T> stopPredicate, final boolean includeLast) {
        final Spliterator src = stream.spliterator();
        Spliterators.AbstractSpliterator split = new Spliterators.AbstractSpliterator<T>(src.estimateSize(), 0){
            boolean done;
            {
                super(arg0, arg1);
                this.done = false;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.done) {
                    return false;
                }
                return src.tryAdvance(elem -> {
                    boolean t = stopPredicate.test(elem);
                    if (t && !includeLast) {
                        this.done = true;
                    }
                    if (!this.done) {
                        consumer.accept(elem);
                    }
                    if (t && includeLast) {
                        this.done = true;
                    }
                });
            }
        };
        return (Stream)StreamSupport.stream(split, false).onClose(stream::close);
    }
}

