/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.Difference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Difference", generator="Immutables")
@Immutable
public final class ImmutableDifference
implements Difference {
    private final Key key;
    @Nullable
    private final ByteString global;
    @Nullable
    private final ByteString fromValue;
    @Nullable
    private final ByteString toValue;
    private transient int hashCode;

    private ImmutableDifference(Key key, @Nullable ByteString global, @Nullable ByteString fromValue, @Nullable ByteString toValue) {
        this.key = key;
        this.global = global;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public Optional<ByteString> getGlobal() {
        return Optional.ofNullable(this.global);
    }

    @Override
    public Optional<ByteString> getFromValue() {
        return Optional.ofNullable(this.fromValue);
    }

    @Override
    public Optional<ByteString> getToValue() {
        return Optional.ofNullable(this.toValue);
    }

    public final ImmutableDifference withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDifference(newValue, this.global, this.fromValue, this.toValue);
    }

    public final ImmutableDifference withGlobal(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "global");
        if (this.global == newValue) {
            return this;
        }
        return new ImmutableDifference(this.key, newValue, this.fromValue, this.toValue);
    }

    public final ImmutableDifference withGlobal(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.global == value) {
            return this;
        }
        return new ImmutableDifference(this.key, value, this.fromValue, this.toValue);
    }

    public final ImmutableDifference withFromValue(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "fromValue");
        if (this.fromValue == newValue) {
            return this;
        }
        return new ImmutableDifference(this.key, this.global, newValue, this.toValue);
    }

    public final ImmutableDifference withFromValue(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.fromValue == value) {
            return this;
        }
        return new ImmutableDifference(this.key, this.global, value, this.toValue);
    }

    public final ImmutableDifference withToValue(ByteString value) {
        ByteString newValue = Objects.requireNonNull(value, "toValue");
        if (this.toValue == newValue) {
            return this;
        }
        return new ImmutableDifference(this.key, this.global, this.fromValue, newValue);
    }

    public final ImmutableDifference withToValue(Optional<? extends ByteString> optional) {
        ByteString value = optional.orElse(null);
        if (this.toValue == value) {
            return this;
        }
        return new ImmutableDifference(this.key, this.global, this.fromValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDifference && this.equalTo((ImmutableDifference)another);
    }

    private boolean equalTo(ImmutableDifference another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals((Object)another.key) && Objects.equals(this.global, another.global) && Objects.equals(this.fromValue, another.fromValue) && Objects.equals(this.toValue, another.toValue);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.global);
        h += (h << 5) + Objects.hashCode(this.fromValue);
        h += (h << 5) + Objects.hashCode(this.toValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Difference").omitNullValues().add("key", (Object)this.key).add("global", (Object)this.global).add("fromValue", (Object)this.fromValue).add("toValue", (Object)this.toValue).toString();
    }

    public static ImmutableDifference copyOf(Difference instance) {
        if (instance instanceof ImmutableDifference) {
            return (ImmutableDifference)instance;
        }
        return ImmutableDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Difference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private Key key;
        @Nullable
        private ByteString global;
        @Nullable
        private ByteString fromValue;
        @Nullable
        private ByteString toValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Difference instance) {
            Optional<ByteString> toValueOptional;
            Optional<ByteString> fromValueOptional;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Optional<ByteString> globalOptional = instance.getGlobal();
            if (globalOptional.isPresent()) {
                this.global(globalOptional);
            }
            if ((fromValueOptional = instance.getFromValue()).isPresent()) {
                this.fromValue(fromValueOptional);
            }
            if ((toValueOptional = instance.getToValue()).isPresent()) {
                this.toValue(toValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(ByteString global) {
            this.global = Objects.requireNonNull(global, "global");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(Optional<? extends ByteString> global) {
            this.global = global.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(ByteString fromValue) {
            this.fromValue = Objects.requireNonNull(fromValue, "fromValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Optional<? extends ByteString> fromValue) {
            this.fromValue = fromValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(ByteString toValue) {
            this.toValue = Objects.requireNonNull(toValue, "toValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Optional<? extends ByteString> toValue) {
            this.toValue = toValue.orElse(null);
            return this;
        }

        public ImmutableDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDifference(this.key, this.global, this.fromValue, this.toValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Difference, some of required attributes are not set " + attributes;
        }
    }
}

