/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitLogEntry", generator="Immutables")
@Immutable
public final class ImmutableCommitLogEntry
implements CommitLogEntry {
    private final long createdTime;
    private final Hash hash;
    private final ImmutableList<Hash> parents;
    private final ByteString metadata;
    private final ImmutableList<KeyWithBytes> puts;
    private final ImmutableList<Key> deletes;
    @Nullable
    private final KeyList keyList;
    private final ImmutableList<Hash> keyListsIds;
    private final int keyListDistance;
    private transient int hashCode;

    private ImmutableCommitLogEntry(long createdTime, Hash hash, ImmutableList<Hash> parents, ByteString metadata, ImmutableList<KeyWithBytes> puts, ImmutableList<Key> deletes, @Nullable KeyList keyList, ImmutableList<Hash> keyListsIds, int keyListDistance) {
        this.createdTime = createdTime;
        this.hash = hash;
        this.parents = parents;
        this.metadata = metadata;
        this.puts = puts;
        this.deletes = deletes;
        this.keyList = keyList;
        this.keyListsIds = keyListsIds;
        this.keyListDistance = keyListDistance;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    public ImmutableList<Hash> getParents() {
        return this.parents;
    }

    @Override
    public ByteString getMetadata() {
        return this.metadata;
    }

    public ImmutableList<KeyWithBytes> getPuts() {
        return this.puts;
    }

    public ImmutableList<Key> getDeletes() {
        return this.deletes;
    }

    @Override
    @Nullable
    public KeyList getKeyList() {
        return this.keyList;
    }

    public ImmutableList<Hash> getKeyListsIds() {
        return this.keyListsIds;
    }

    @Override
    public int getKeyListDistance() {
        return this.keyListDistance;
    }

    public final ImmutableCommitLogEntry withCreatedTime(long value) {
        if (this.createdTime == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(value, this.hash, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableCommitLogEntry(this.createdTime, newValue, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withParents(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, (ImmutableList<Hash>)newValue, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withParents(Iterable<? extends Hash> elements) {
        if (this.parents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, (ImmutableList<Hash>)newValue, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withMetadata(ByteString value) {
        if (this.metadata == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, newValue, this.puts, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withPuts(KeyWithBytes ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, (ImmutableList<KeyWithBytes>)newValue, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withPuts(Iterable<? extends KeyWithBytes> elements) {
        if (this.puts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, (ImmutableList<KeyWithBytes>)newValue, this.deletes, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withDeletes(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, (ImmutableList<Key>)newValue, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withDeletes(Iterable<? extends Key> elements) {
        if (this.deletes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, (ImmutableList<Key>)newValue, this.keyList, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withKeyList(@Nullable KeyList value) {
        if (this.keyList == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, this.deletes, value, this.keyListsIds, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withKeyListsIds(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, this.deletes, this.keyList, (ImmutableList<Hash>)newValue, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withKeyListsIds(Iterable<? extends Hash> elements) {
        if (this.keyListsIds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, this.deletes, this.keyList, (ImmutableList<Hash>)newValue, this.keyListDistance);
    }

    public final ImmutableCommitLogEntry withKeyListDistance(int value) {
        if (this.keyListDistance == value) {
            return this;
        }
        return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents, this.metadata, this.puts, this.deletes, this.keyList, this.keyListsIds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitLogEntry && this.equalTo((ImmutableCommitLogEntry)another);
    }

    private boolean equalTo(ImmutableCommitLogEntry another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.createdTime == another.createdTime && this.hash.equals((Object)another.hash) && this.parents.equals(another.parents) && this.metadata.equals((Object)another.metadata) && this.puts.equals(another.puts) && this.deletes.equals(another.deletes) && Objects.equals(this.keyList, another.keyList) && this.keyListsIds.equals(another.keyListsIds) && this.keyListDistance == another.keyListDistance;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.createdTime);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.parents.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.puts.hashCode();
        h += (h << 5) + this.deletes.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyList);
        h += (h << 5) + this.keyListsIds.hashCode();
        h += (h << 5) + this.keyListDistance;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitLogEntry").omitNullValues().add("createdTime", this.createdTime).add("hash", (Object)this.hash).add("parents", this.parents).add("metadata", (Object)this.metadata).add("puts", this.puts).add("deletes", this.deletes).add("keyList", (Object)this.keyList).add("keyListsIds", this.keyListsIds).add("keyListDistance", this.keyListDistance).toString();
    }

    public static ImmutableCommitLogEntry copyOf(CommitLogEntry instance) {
        if (instance instanceof ImmutableCommitLogEntry) {
            return (ImmutableCommitLogEntry)instance;
        }
        return ImmutableCommitLogEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitLogEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATED_TIME = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_METADATA = 4L;
        private static final long INIT_BIT_KEY_LIST_DISTANCE = 8L;
        private long initBits = 15L;
        private long createdTime;
        @Nullable
        private Hash hash;
        private ImmutableList.Builder<Hash> parents = ImmutableList.builder();
        @Nullable
        private ByteString metadata;
        private ImmutableList.Builder<KeyWithBytes> puts = ImmutableList.builder();
        private ImmutableList.Builder<Key> deletes = ImmutableList.builder();
        @Nullable
        private KeyList keyList;
        private ImmutableList.Builder<Hash> keyListsIds = ImmutableList.builder();
        private int keyListDistance;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitLogEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.createdTime(instance.getCreatedTime());
            this.hash(instance.getHash());
            this.addAllParents(instance.getParents());
            this.metadata(instance.getMetadata());
            this.addAllPuts(instance.getPuts());
            this.addAllDeletes(instance.getDeletes());
            KeyList keyListValue = instance.getKeyList();
            if (keyListValue != null) {
                this.keyList(keyListValue);
            }
            this.addAllKeyListsIds(instance.getKeyListsIds());
            this.keyListDistance(instance.getKeyListDistance());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdTime(long createdTime) {
            this.createdTime = createdTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(Hash element) {
            this.parents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParents(Hash ... elements) {
            this.parents.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parents(Iterable<? extends Hash> elements) {
            this.parents = ImmutableList.builder();
            return this.addAllParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParents(Iterable<? extends Hash> elements) {
            this.parents.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(ByteString metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes element) {
            this.puts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes ... elements) {
            this.puts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder puts(Iterable<? extends KeyWithBytes> elements) {
            this.puts = ImmutableList.builder();
            return this.addAllPuts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPuts(Iterable<? extends KeyWithBytes> elements) {
            this.puts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key element) {
            this.deletes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key ... elements) {
            this.deletes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletes(Iterable<? extends Key> elements) {
            this.deletes = ImmutableList.builder();
            return this.addAllDeletes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeletes(Iterable<? extends Key> elements) {
            this.deletes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyList(@Nullable KeyList keyList) {
            this.keyList = keyList;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListsIds(Hash element) {
            this.keyListsIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyListsIds(Hash ... elements) {
            this.keyListsIds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListsIds(Iterable<? extends Hash> elements) {
            this.keyListsIds = ImmutableList.builder();
            return this.addAllKeyListsIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyListsIds(Iterable<? extends Hash> elements) {
            this.keyListsIds.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCommitLogEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitLogEntry(this.createdTime, this.hash, this.parents.build(), this.metadata, this.puts.build(), this.deletes.build(), this.keyList, this.keyListsIds.build(), this.keyListDistance);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("keyListDistance");
            }
            return "Cannot build CommitLogEntry, some of required attributes are not set " + attributes;
        }
    }
}

