/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.MockManifestFile;

@Value.Immutable
public abstract class MockManifestList {
    static final Schema V2_SCHEMA = new Schema(new Types.NestedField[]{ManifestFile.PATH, ManifestFile.LENGTH, ManifestFile.SPEC_ID, ManifestFile.MANIFEST_CONTENT.asRequired(), ManifestFile.SEQUENCE_NUMBER.asRequired(), ManifestFile.MIN_SEQUENCE_NUMBER.asRequired(), ManifestFile.SNAPSHOT_ID.asRequired(), ManifestFile.ADDED_FILES_COUNT.asRequired(), ManifestFile.EXISTING_FILES_COUNT.asRequired(), ManifestFile.DELETED_FILES_COUNT.asRequired(), ManifestFile.ADDED_ROWS_COUNT.asRequired(), ManifestFile.EXISTING_ROWS_COUNT.asRequired(), ManifestFile.DELETED_ROWS_COUNT.asRequired(), ManifestFile.PARTITION_SUMMARIES});

    public abstract List<MockManifestFile> manifestFiles();

    public void write(OutputFile output, long snapshotId, long parentSnapshotId, long sequenceNumber) {
        try (FileAppender writer = Avro.write((OutputFile)output).schema(V2_SCHEMA).named("manifest_file").meta((Map)ImmutableMap.of((Object)"snapshot-id", (Object)String.valueOf(snapshotId), (Object)"parent-snapshot-id", (Object)String.valueOf(parentSnapshotId), (Object)"sequence-number", (Object)String.valueOf(sequenceNumber), (Object)"format-version", (Object)"2")).overwrite().build();){
            for (MockManifestFile manifestFile : this.manifestFiles()) {
                writer.add((Object)manifestFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

