/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import jakarta.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.BridgeToIceberg;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.MockManifestFile;

@Value.Immutable
public abstract class MockManifestEntry
implements IndexedRecord {
    static final Types.NestedField STATUS = Types.NestedField.required((int)0, (String)"status", (Type)Types.IntegerType.get());
    static final Types.NestedField SNAPSHOT_ID = Types.NestedField.optional((int)1, (String)"snapshot_id", (Type)Types.LongType.get());
    static final Types.NestedField SEQUENCE_NUMBER = Types.NestedField.optional((int)3, (String)"sequence_number", (Type)Types.LongType.get());
    static final int DATA_FILE_ID = 2;

    @Value.Default
    public Status status() {
        return Status.ADDED;
    }

    @Nullable
    public abstract Long snapshotId();

    @Nullable
    public abstract Long sequenceNumber();

    public abstract String filePath();

    public abstract Types.StructType partitionType();

    @Value.Auxiliary
    public Schema getSchema() {
        Types.StructType fileSchema = MockManifestFile.fileType(this.partitionType());
        return AvroSchemaUtil.convert((org.apache.iceberg.Schema)new org.apache.iceberg.Schema(new Types.NestedField[]{STATUS, SNAPSHOT_ID, SEQUENCE_NUMBER, Types.NestedField.required((int)2, (String)"data_file", (Type)fileSchema)}), (String)"manifest_entry");
    }

    public void put(int i, Object v) {
        throw new UnsupportedOperationException();
    }

    public Object get(int i) {
        String field;
        switch (field = ((Schema.Field)this.getSchema().getFields().get(i)).name()) {
            case "status": {
                return this.status().ordinal();
            }
            case "snapshot_id": {
                return this.snapshotId();
            }
            case "sequence_number": {
                return this.sequenceNumber();
            }
            case "data_file": {
                return BridgeToIceberg.dummyIndexedDataFile(this.filePath(), this.partitionType());
            }
        }
        throw new IllegalArgumentException("Unknown field '" + field + "'");
    }

    static enum Status {
        EXISTING,
        ADDED,
        DELETED;

    }
}

