/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockSchema;
import org.projectnessie.gc.iceberg.mocks.MockSnapshot;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockSnapshot", generator="Immutables")
@Immutable
public final class ImmutableMockSnapshot
extends MockSnapshot {
    @jakarta.annotation.Nullable
    private final String manifestListLocation;
    private final long sequenceNumber;
    private final long snapshotId;
    private final long timestampMs;
    private final String summaryOperation;
    private final MockPartitionSpec partitionSpec;
    private final MockSchema schema;
    private final String tableUuid;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockSnapshot(Builder builder) {
        this.manifestListLocation = builder.manifestListLocation;
        this.tableUuid = builder.tableUuid;
        if (builder.sequenceNumberIsSet()) {
            this.initShim.sequenceNumber(builder.sequenceNumber);
        }
        if (builder.snapshotIdIsSet()) {
            this.initShim.snapshotId(builder.snapshotId);
        }
        if (builder.timestampMsIsSet()) {
            this.initShim.timestampMs(builder.timestampMs);
        }
        if (builder.summaryOperation != null) {
            this.initShim.summaryOperation(builder.summaryOperation);
        }
        if (builder.partitionSpec != null) {
            this.initShim.partitionSpec(builder.partitionSpec);
        }
        if (builder.schema != null) {
            this.initShim.schema(builder.schema);
        }
        this.sequenceNumber = this.initShim.sequenceNumber();
        this.snapshotId = this.initShim.snapshotId();
        this.timestampMs = this.initShim.timestampMs();
        this.summaryOperation = this.initShim.summaryOperation();
        this.partitionSpec = this.initShim.partitionSpec();
        this.schema = this.initShim.schema();
        this.initShim = null;
    }

    private ImmutableMockSnapshot(@jakarta.annotation.Nullable String manifestListLocation, long sequenceNumber, long snapshotId, long timestampMs, String summaryOperation, MockPartitionSpec partitionSpec, MockSchema schema, String tableUuid) {
        this.manifestListLocation = manifestListLocation;
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.timestampMs = timestampMs;
        this.summaryOperation = summaryOperation;
        this.partitionSpec = partitionSpec;
        this.schema = schema;
        this.tableUuid = tableUuid;
        this.initShim = null;
    }

    @Override
    @jakarta.annotation.Nullable
    public String manifestListLocation() {
        return this.manifestListLocation;
    }

    @Override
    public long sequenceNumber() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sequenceNumber() : this.sequenceNumber;
    }

    @Override
    public long snapshotId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.snapshotId() : this.snapshotId;
    }

    @Override
    public long timestampMs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.timestampMs() : this.timestampMs;
    }

    @Override
    public String summaryOperation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.summaryOperation() : this.summaryOperation;
    }

    @Override
    public MockPartitionSpec partitionSpec() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitionSpec() : this.partitionSpec;
    }

    @Override
    public MockSchema schema() {
        InitShim shim = this.initShim;
        return shim != null ? shim.schema() : this.schema;
    }

    @Override
    public String tableUuid() {
        return this.tableUuid;
    }

    public final ImmutableMockSnapshot withManifestListLocation(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.manifestListLocation, value)) {
            return this;
        }
        return new ImmutableMockSnapshot(value, this.sequenceNumber, this.snapshotId, this.timestampMs, this.summaryOperation, this.partitionSpec, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withSequenceNumber(long value) {
        if (this.sequenceNumber == value) {
            return this;
        }
        return new ImmutableMockSnapshot(this.manifestListLocation, value, this.snapshotId, this.timestampMs, this.summaryOperation, this.partitionSpec, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, value, this.timestampMs, this.summaryOperation, this.partitionSpec, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withTimestampMs(long value) {
        if (this.timestampMs == value) {
            return this;
        }
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, this.snapshotId, value, this.summaryOperation, this.partitionSpec, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withSummaryOperation(String value) {
        String newValue = Objects.requireNonNull(value, "summaryOperation");
        if (this.summaryOperation.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, this.snapshotId, this.timestampMs, newValue, this.partitionSpec, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withPartitionSpec(MockPartitionSpec value) {
        if (this.partitionSpec == value) {
            return this;
        }
        MockPartitionSpec newValue = Objects.requireNonNull(value, "partitionSpec");
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, this.snapshotId, this.timestampMs, this.summaryOperation, newValue, this.schema, this.tableUuid);
    }

    public final ImmutableMockSnapshot withSchema(MockSchema value) {
        if (this.schema == value) {
            return this;
        }
        MockSchema newValue = Objects.requireNonNull(value, "schema");
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, this.snapshotId, this.timestampMs, this.summaryOperation, this.partitionSpec, newValue, this.tableUuid);
    }

    public final ImmutableMockSnapshot withTableUuid(String value) {
        String newValue = Objects.requireNonNull(value, "tableUuid");
        if (this.tableUuid.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSnapshot(this.manifestListLocation, this.sequenceNumber, this.snapshotId, this.timestampMs, this.summaryOperation, this.partitionSpec, this.schema, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockSnapshot && this.equalTo(0, (ImmutableMockSnapshot)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockSnapshot another) {
        return Objects.equals(this.manifestListLocation, another.manifestListLocation) && this.sequenceNumber == another.sequenceNumber && this.snapshotId == another.snapshotId && this.timestampMs == another.timestampMs && this.summaryOperation.equals(another.summaryOperation) && this.partitionSpec.equals(another.partitionSpec) && this.schema.equals(another.schema) && this.tableUuid.equals(another.tableUuid);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.manifestListLocation);
        h += (h << 5) + Longs.hashCode((long)this.sequenceNumber);
        h += (h << 5) + Longs.hashCode((long)this.snapshotId);
        h += (h << 5) + Longs.hashCode((long)this.timestampMs);
        h += (h << 5) + this.summaryOperation.hashCode();
        h += (h << 5) + this.partitionSpec.hashCode();
        h += (h << 5) + this.schema.hashCode();
        h += (h << 5) + this.tableUuid.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockSnapshot").omitNullValues().add("manifestListLocation", (Object)this.manifestListLocation).add("sequenceNumber", this.sequenceNumber).add("snapshotId", this.snapshotId).add("timestampMs", this.timestampMs).add("summaryOperation", (Object)this.summaryOperation).add("partitionSpec", (Object)this.partitionSpec).add("schema", (Object)this.schema).add("tableUuid", (Object)this.tableUuid).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockSnapshot immutableMockSnapshot = this;
            synchronized (immutableMockSnapshot) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockSnapshot copyOf(MockSnapshot instance) {
        if (instance instanceof ImmutableMockSnapshot) {
            return (ImmutableMockSnapshot)instance;
        }
        return ImmutableMockSnapshot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockSnapshot", generator="Immutables")
    private final class InitShim {
        private byte sequenceNumberBuildStage = 0;
        private long sequenceNumber;
        private byte snapshotIdBuildStage = 0;
        private long snapshotId;
        private byte timestampMsBuildStage = 0;
        private long timestampMs;
        private byte summaryOperationBuildStage = 0;
        private String summaryOperation;
        private byte partitionSpecBuildStage = 0;
        private MockPartitionSpec partitionSpec;
        private byte schemaBuildStage = 0;
        private MockSchema schema;

        private InitShim() {
        }

        long sequenceNumber() {
            if (this.sequenceNumberBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sequenceNumberBuildStage == 0) {
                this.sequenceNumberBuildStage = (byte)-1;
                this.sequenceNumber = ImmutableMockSnapshot.super.sequenceNumber();
                this.sequenceNumberBuildStage = 1;
            }
            return this.sequenceNumber;
        }

        void sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.sequenceNumberBuildStage = 1;
        }

        long snapshotId() {
            if (this.snapshotIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.snapshotIdBuildStage == 0) {
                this.snapshotIdBuildStage = (byte)-1;
                this.snapshotId = ImmutableMockSnapshot.super.snapshotId();
                this.snapshotIdBuildStage = 1;
            }
            return this.snapshotId;
        }

        void snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.snapshotIdBuildStage = 1;
        }

        long timestampMs() {
            if (this.timestampMsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timestampMsBuildStage == 0) {
                this.timestampMsBuildStage = (byte)-1;
                this.timestampMs = ImmutableMockSnapshot.super.timestampMs();
                this.timestampMsBuildStage = 1;
            }
            return this.timestampMs;
        }

        void timestampMs(long timestampMs) {
            this.timestampMs = timestampMs;
            this.timestampMsBuildStage = 1;
        }

        String summaryOperation() {
            if (this.summaryOperationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.summaryOperationBuildStage == 0) {
                this.summaryOperationBuildStage = (byte)-1;
                this.summaryOperation = Objects.requireNonNull(ImmutableMockSnapshot.super.summaryOperation(), "summaryOperation");
                this.summaryOperationBuildStage = 1;
            }
            return this.summaryOperation;
        }

        void summaryOperation(String summaryOperation) {
            this.summaryOperation = summaryOperation;
            this.summaryOperationBuildStage = 1;
        }

        MockPartitionSpec partitionSpec() {
            if (this.partitionSpecBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitionSpecBuildStage == 0) {
                this.partitionSpecBuildStage = (byte)-1;
                this.partitionSpec = Objects.requireNonNull(ImmutableMockSnapshot.super.partitionSpec(), "partitionSpec");
                this.partitionSpecBuildStage = 1;
            }
            return this.partitionSpec;
        }

        void partitionSpec(MockPartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            this.partitionSpecBuildStage = 1;
        }

        MockSchema schema() {
            if (this.schemaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaBuildStage == 0) {
                this.schemaBuildStage = (byte)-1;
                this.schema = Objects.requireNonNull(ImmutableMockSnapshot.super.schema(), "schema");
                this.schemaBuildStage = 1;
            }
            return this.schema;
        }

        void schema(MockSchema schema) {
            this.schema = schema;
            this.schemaBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sequenceNumberBuildStage == -1) {
                attributes.add("sequenceNumber");
            }
            if (this.snapshotIdBuildStage == -1) {
                attributes.add("snapshotId");
            }
            if (this.timestampMsBuildStage == -1) {
                attributes.add("timestampMs");
            }
            if (this.summaryOperationBuildStage == -1) {
                attributes.add("summaryOperation");
            }
            if (this.partitionSpecBuildStage == -1) {
                attributes.add("partitionSpec");
            }
            if (this.schemaBuildStage == -1) {
                attributes.add("schema");
            }
            return "Cannot build MockSnapshot, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MockSnapshot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_UUID = 1L;
        private static final long OPT_BIT_SEQUENCE_NUMBER = 1L;
        private static final long OPT_BIT_SNAPSHOT_ID = 2L;
        private static final long OPT_BIT_TIMESTAMP_MS = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String manifestListLocation;
        private long sequenceNumber;
        private long snapshotId;
        private long timestampMs;
        @Nullable
        private String summaryOperation;
        @Nullable
        private MockPartitionSpec partitionSpec;
        @Nullable
        private MockSchema schema;
        @Nullable
        private String tableUuid;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockSnapshot instance) {
            Objects.requireNonNull(instance, "instance");
            String manifestListLocationValue = instance.manifestListLocation();
            if (manifestListLocationValue != null) {
                this.manifestListLocation(manifestListLocationValue);
            }
            this.sequenceNumber(instance.sequenceNumber());
            this.snapshotId(instance.snapshotId());
            this.timestampMs(instance.timestampMs());
            this.summaryOperation(instance.summaryOperation());
            this.partitionSpec(instance.partitionSpec());
            this.schema(instance.schema());
            this.tableUuid(instance.tableUuid());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder manifestListLocation(@jakarta.annotation.Nullable String manifestListLocation) {
            this.manifestListLocation = manifestListLocation;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampMs(long timestampMs) {
            this.timestampMs = timestampMs;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder summaryOperation(String summaryOperation) {
            this.summaryOperation = Objects.requireNonNull(summaryOperation, "summaryOperation");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionSpec(MockPartitionSpec partitionSpec) {
            this.partitionSpec = Objects.requireNonNull(partitionSpec, "partitionSpec");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schema(MockSchema schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableUuid(String tableUuid) {
            this.tableUuid = Objects.requireNonNull(tableUuid, "tableUuid");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMockSnapshot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMockSnapshot(this);
        }

        private boolean sequenceNumberIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean snapshotIdIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean timestampMsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableUuid");
            }
            return "Cannot build MockSnapshot, some of required attributes are not set " + attributes;
        }
    }
}

