/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iceberg.io.OutputFile;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.IcebergFileIOMocking;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockManifestFile;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockManifestList;
import org.projectnessie.gc.iceberg.mocks.MockManifestFile;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockSchema;

@Value.Immutable
public abstract class MockSnapshot {
    @Value.Lazy
    public JsonNode jsonNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("sequence-number", this.sequenceNumber()).put("snapshot-id", this.snapshotId()).put("timestamp-ms", this.timestampMs());
        this.summary(node.putObject("summary"));
        if (this.manifestListLocation() != null) {
            node.put("manifest-list", this.manifestListLocation());
        }
        node.putArray("manifests");
        return node;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public abstract String manifestListLocation();

    @Value.Default
    public long sequenceNumber() {
        return 0L;
    }

    @Value.Default
    public long snapshotId() {
        return 0L;
    }

    @Value.Default
    public long timestampMs() {
        return 0L;
    }

    @Value.Default
    public String summaryOperation() {
        return "snapshot-operation";
    }

    private void summary(ObjectNode summary) {
        summary.put("operation", this.summaryOperation());
    }

    @Value.Default
    public MockPartitionSpec partitionSpec() {
        return MockPartitionSpec.DEFAULT_EMPTY;
    }

    @Value.Default
    public MockSchema schema() {
        return MockSchema.DEFAULT_EMPTY;
    }

    public abstract String tableUuid();

    @Value.Auxiliary
    public Stream<MockManifestFile> manifestFiles() {
        return Stream.of(ImmutableMockManifestFile.builder().path(IcebergFileIOMocking.manifestFileLocation(this.tableUuid(), this.snapshotId(), 0)).addedFilesCount(1).addedRowsCount(1L).snapshotId(this.snapshotId()).partitionSpecId(this.partitionSpec().specId()).baseDataFilePath(IcebergFileIOMocking.dataFileBase(this.tableUuid(), this.snapshotId(), 0)).build());
    }

    public void generateManifestList(OutputFile output) {
        ImmutableMockManifestList.Builder manifestList = ImmutableMockManifestList.builder();
        this.manifestFiles().forEach(manifestList::addManifestFiles);
        manifestList.build().write(output, this.snapshotId(), -1L, 0L);
    }
}

