/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockField;
import org.projectnessie.gc.iceberg.mocks.MockField;
import org.projectnessie.gc.iceberg.mocks.MockTableMetadata;

@Value.Immutable
public abstract class MockSchema {
    public static final MockSchema DEFAULT_EMPTY = MockTableMetadata.empty().schema(0);

    @Value.Lazy
    public JsonNode jsonNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("type", this.type()).put("schema-id", this.schemaId());
        this.fields(node.putArray("fields"));
        return node;
    }

    @Value.Default
    public List<MockField> fields() {
        return Collections.singletonList(ImmutableMockField.builder().build());
    }

    private void fields(ArrayNode fields) {
        for (MockField field : this.fields()) {
            fields.add(field.jsonNode());
        }
    }

    @Value.Default
    public String type() {
        return "struct";
    }

    @Value.Default
    public int schemaId() {
        return 0;
    }

    public Schema toSchema() {
        return new Schema(this.schemaId(), this.fields().stream().map(MockField::toNestedField).collect(Collectors.toList()));
    }
}

