/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockPartitionSpecField;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpecField;
import org.projectnessie.gc.iceberg.mocks.MockTableMetadata;

@Value.Immutable
public abstract class MockPartitionSpec {
    public static final MockPartitionSpec DEFAULT_EMPTY = MockTableMetadata.empty().partitionSpec(0);

    @Value.Lazy
    public JsonNode jsonNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("spec-id", this.specId());
        this.fields(node.putArray("fields"));
        return node;
    }

    @Value.Default
    public List<MockPartitionSpecField> fields() {
        return Collections.singletonList(ImmutableMockPartitionSpecField.builder().build());
    }

    private void fields(ArrayNode fields) {
        for (MockPartitionSpecField field : this.fields()) {
            fields.add(field.jsonNode());
        }
    }

    @Value.Default
    public int specId() {
        return 0;
    }

    public PartitionSpec toPartitionSpec(Schema schema) {
        PartitionSpec.Builder partitionSpecBuilder = PartitionSpec.builderFor((Schema)schema).withSpecId(this.specId());
        this.fields().forEach(f -> partitionSpecBuilder.identity(f.name()));
        return partitionSpecBuilder.build();
    }
}

