/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockSchema;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockSortOrder;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockTableMetadata;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockSchema;
import org.projectnessie.gc.iceberg.mocks.MockSnapshot;
import org.projectnessie.gc.iceberg.mocks.MockSortOrder;

@Value.Immutable
public abstract class MockTableMetadata {
    public static final int FORMAT_VERSION = 2;

    public static MockTableMetadata empty() {
        return ImmutableMockTableMetadata.builder().location("nope://").build();
    }

    @Value.Lazy
    public JsonNode jsonNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("format-version", 2).put("table-uuid", this.tableUuid()).put("location", this.location()).put("last-sequence-number", this.lastSequenceNumber()).put("last-updated-ms", this.lastUpdatedMs()).put("last-column-id", this.lastColumnId()).put("current-schema-id", this.currentSchemaId());
        this.schemas(node.putArray("schemas"));
        node.put("default-spec-id", this.defaultSpecId());
        this.partitionSpecs(node.putArray("partition-specs"));
        node.put("last-partition-id", this.lastPartitionId()).put("default-sort-order-id", this.defaultSortOrderId());
        this.sortOrders(node.putArray("sort-orders"));
        node.putObject("properties");
        node.put("current-snapshot-id", this.currentSnapshotId());
        this.snapshots(node.putArray("snapshots"));
        node.putArray("snapshot-log");
        node.putArray("metadata-log");
        return node;
    }

    public abstract List<MockSnapshot> snapshots();

    @Value.Default
    public List<MockSchema> schemas() {
        return Collections.singletonList(ImmutableMockSchema.builder().build());
    }

    @Value.Default
    public List<MockSortOrder> sortOrders() {
        return Collections.singletonList(ImmutableMockSortOrder.builder().build());
    }

    @Value.Default
    public List<MockPartitionSpec> partitionSpecs() {
        return Collections.singletonList(ImmutableMockPartitionSpec.builder().build());
    }

    private void schemas(ArrayNode schemas) {
        for (MockSchema schema : this.schemas()) {
            schemas.add(schema.jsonNode());
        }
    }

    private void partitionSpecs(ArrayNode partitionSpecs) {
        for (MockPartitionSpec partitionSpec : this.partitionSpecs()) {
            partitionSpecs.add(partitionSpec.jsonNode());
        }
    }

    private void sortOrders(ArrayNode sortOrders) {
        for (MockSortOrder sortOrder : this.sortOrders()) {
            sortOrders.add(sortOrder.jsonNode());
        }
    }

    private void snapshots(ArrayNode snapshots) {
        for (MockSnapshot snapshot : this.snapshots()) {
            snapshots.add(snapshot.jsonNode());
        }
    }

    @Value.Default
    public long currentSnapshotId() {
        return 0L;
    }

    @Value.Default
    public int defaultSortOrderId() {
        return 0;
    }

    @Value.Default
    public int lastPartitionId() {
        return 0;
    }

    @Value.Default
    public int defaultSpecId() {
        return 0;
    }

    @Value.Default
    public int currentSchemaId() {
        return 0;
    }

    @Value.Default
    public int lastColumnId() {
        return 0;
    }

    @Value.Default
    public long lastUpdatedMs() {
        return 0L;
    }

    @Value.Default
    public int lastSequenceNumber() {
        return 0;
    }

    public abstract String location();

    @Value.Default
    public String tableUuid() {
        return UUID.randomUUID().toString();
    }

    public MockPartitionSpec partitionSpec(int partitionSpecId) {
        for (MockPartitionSpec partitionSpec : this.partitionSpecs()) {
            if (partitionSpec.specId() != partitionSpecId) continue;
            return partitionSpec;
        }
        throw new IllegalArgumentException();
    }

    public MockSchema schema(int schemaId) {
        for (MockSchema schema : this.schemas()) {
            if (schema.schemaId() != schemaId) continue;
            return schema;
        }
        throw new IllegalArgumentException();
    }
}

