/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockField;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockField", generator="Immutables")
@Immutable
public final class ImmutableMockField
extends MockField {
    private final int id;
    private final String name;
    private final boolean required;
    private final String type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockField(Builder builder) {
        if (builder.idIsSet()) {
            this.initShim.id(builder.id);
        }
        if (builder.name != null) {
            this.initShim.name(builder.name);
        }
        if (builder.requiredIsSet()) {
            this.initShim.required(builder.required);
        }
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        this.id = this.initShim.id();
        this.name = this.initShim.name();
        this.required = this.initShim.required();
        this.type = this.initShim.type();
        this.initShim = null;
    }

    private ImmutableMockField(int id, String name, boolean required, String type) {
        this.id = id;
        this.name = name;
        this.required = required;
        this.type = type;
        this.initShim = null;
    }

    @Override
    public int id() {
        InitShim shim = this.initShim;
        return shim != null ? shim.id() : this.id;
    }

    @Override
    public String name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    public boolean required() {
        InitShim shim = this.initShim;
        return shim != null ? shim.required() : this.required;
    }

    @Override
    public String type() {
        InitShim shim = this.initShim;
        return shim != null ? shim.type() : this.type;
    }

    public final ImmutableMockField withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableMockField(value, this.name, this.required, this.type);
    }

    public final ImmutableMockField withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMockField(this.id, newValue, this.required, this.type);
    }

    public final ImmutableMockField withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableMockField(this.id, this.name, value, this.type);
    }

    public final ImmutableMockField withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableMockField(this.id, this.name, this.required, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockField && this.equalTo(0, (ImmutableMockField)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockField another) {
        return this.id == another.id && this.name.equals(another.name) && this.required == another.required && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.required);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockField").omitNullValues().add("id", this.id).add("name", (Object)this.name).add("required", this.required).add("type", (Object)this.type).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockField immutableMockField = this;
            synchronized (immutableMockField) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockField copyOf(MockField instance) {
        if (instance instanceof ImmutableMockField) {
            return (ImmutableMockField)instance;
        }
        return ImmutableMockField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockField", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_ID = 1L;
        private static final long OPT_BIT_REQUIRED = 2L;
        private long optBits;
        private int id;
        @Nullable
        private String name;
        private boolean required;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockField instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.required(instance.required());
            this.type(instance.type());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder required(boolean required) {
            this.required = required;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public ImmutableMockField build() {
            return new ImmutableMockField(this);
        }

        private boolean idIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean requiredIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="MockField", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private int id;
        private byte nameBuildStage = 0;
        private String name;
        private byte requiredBuildStage = 0;
        private boolean required;
        private byte typeBuildStage = 0;
        private String type;

        private InitShim() {
        }

        int id() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = ImmutableMockField.super.id();
                this.idBuildStage = 1;
            }
            return this.id;
        }

        void id(int id) {
            this.id = id;
            this.idBuildStage = 1;
        }

        String name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                this.name = Objects.requireNonNull(ImmutableMockField.super.name(), "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(String name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        boolean required() {
            if (this.requiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requiredBuildStage == 0) {
                this.requiredBuildStage = (byte)-1;
                this.required = ImmutableMockField.super.required();
                this.requiredBuildStage = 1;
            }
            return this.required;
        }

        void required(boolean required) {
            this.required = required;
            this.requiredBuildStage = 1;
        }

        String type() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(ImmutableMockField.super.type(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(String type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.requiredBuildStage == -1) {
                attributes.add("required");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            return "Cannot build MockField, attribute initializers form cycle " + attributes;
        }
    }
}

