/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.IcebergFileIOMocking;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockManifestEntry;
import org.projectnessie.gc.iceberg.mocks.MockManifestEntry;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockTableMetadata;

@Value.Immutable
public abstract class MockManifestFile
implements IndexedRecord {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert((org.apache.iceberg.Schema)ManifestFile.schema(), (String)"manifest_file");

    @javax.annotation.Nonnull
    @Nonnull
    public abstract String path();

    @Value.Default
    public int partitionSpecId() {
        return 0;
    }

    @Value.Default
    public ManifestContent content() {
        return ManifestContent.DATA;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public ByteBuffer keyMetadata() {
        return null;
    }

    @Value.Default
    public long length() {
        return 42L;
    }

    @Value.Default
    public long sequenceNumber() {
        return 0L;
    }

    @Value.Default
    public long minSequenceNumber() {
        return 0L;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Long snapshotId() {
        return 0L;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Integer addedFilesCount() {
        return 0;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Long addedRowsCount() {
        return 0L;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Integer existingFilesCount() {
        return 0;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Long existingRowsCount() {
        return 0L;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Integer deletedFilesCount() {
        return 0;
    }

    @javax.annotation.Nullable
    @Nullable
    @Value.Default
    public Long deletedRowsCount() {
        return 0L;
    }

    @Value.Default
    public int numEntries() {
        return 1;
    }

    public abstract String baseDataFilePath();

    @Value.Auxiliary
    public List<MockManifestEntry> manifestEntries() {
        MockTableMetadata mockTableMeta = MockTableMetadata.empty();
        MockPartitionSpec mockPartitionSpec = mockTableMeta.partitionSpec(0);
        org.apache.iceberg.Schema icebergSchema = mockTableMeta.schema(0).toSchema();
        PartitionSpec partitionSpec = mockPartitionSpec.toPartitionSpec(icebergSchema);
        Types.StructType partitionType = partitionSpec.partitionType();
        return IntStream.range(0, this.numEntries()).mapToObj(i -> ImmutableMockManifestEntry.builder().sequenceNumber(0L).snapshotId(0L).filePath(IcebergFileIOMocking.dataFilePath(this.baseDataFilePath(), i)).partitionType(partitionType).build()).collect(Collectors.toList());
    }

    public void write(OutputFile output) {
        MockTableMetadata mockTableMeta = MockTableMetadata.empty();
        MockPartitionSpec mockPartitionSpec = mockTableMeta.partitionSpec(0);
        org.apache.iceberg.Schema icebergSchema = mockTableMeta.schema(0).toSchema();
        PartitionSpec partitionSpec = mockPartitionSpec.toPartitionSpec(icebergSchema);
        Types.StructType partitionType = partitionSpec.partitionType();
        try {
            String partitionSpecJson = PartitionSpecParser.toJson((PartitionSpec)partitionSpec);
            JsonNode partitionSpecFields = ((JsonNode)MAPPER.readValue(partitionSpecJson, JsonNode.class)).get("fields");
            org.apache.iceberg.Schema manifestSchema = MockManifestFile.entrySchema(partitionType);
            try (FileAppender writer = Avro.write((OutputFile)output).schema(manifestSchema).named("manifest_entry").meta("schema", SchemaParser.toJson((org.apache.iceberg.Schema)icebergSchema)).meta("partition-spec", partitionSpecFields.toString()).meta("partition-spec-id", String.valueOf(this.partitionSpecId())).meta("format-version", "2").meta("content", "deletes").overwrite().build();){
                for (MockManifestEntry entry : this.manifestEntries()) {
                    writer.add((Object)entry);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static org.apache.iceberg.Schema entrySchema(Types.StructType partitionType) {
        return MockManifestFile.wrapFileSchema(MockManifestFile.fileType(partitionType));
    }

    static org.apache.iceberg.Schema wrapFileSchema(Types.StructType fileSchema) {
        return new org.apache.iceberg.Schema(new Types.NestedField[]{MockManifestEntry.STATUS, MockManifestEntry.SNAPSHOT_ID, MockManifestEntry.SEQUENCE_NUMBER, Types.NestedField.required((int)2, (String)"data_file", (Type)fileSchema)});
    }

    static Types.StructType fileType(Types.StructType partitionType) {
        return Types.StructType.of((Types.NestedField[])new Types.NestedField[]{DataFile.CONTENT.asRequired(), DataFile.FILE_PATH, DataFile.FILE_FORMAT, Types.NestedField.required((int)102, (String)"partition", (Type)partitionType, (String)"Partition data tuple, schema based on the partition spec"), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.EQUALITY_IDS, DataFile.SORT_ORDER_ID});
    }

    @Value.Auxiliary
    public Schema getSchema() {
        return AVRO_SCHEMA;
    }

    public void put(int i, Object v) {
        throw new UnsupportedOperationException();
    }

    public Object get(int i) {
        String field;
        switch (field = ((Schema.Field)AVRO_SCHEMA.getFields().get(i)).name()) {
            case "manifest_path": {
                return this.path();
            }
            case "manifest_length": {
                return this.length();
            }
            case "partition_spec_id": {
                return this.partitionSpecId();
            }
            case "content": {
                return this.content().ordinal();
            }
            case "sequence_number": {
                return this.sequenceNumber();
            }
            case "min_sequence_number": {
                return this.minSequenceNumber();
            }
            case "added_snapshot_id": {
                return this.snapshotId();
            }
            case "added_data_files_count": {
                return this.addedFilesCount();
            }
            case "existing_data_files_count": {
                return this.existingFilesCount();
            }
            case "deleted_data_files_count": {
                return this.deletedFilesCount();
            }
            case "added_rows_count": {
                return this.addedRowsCount();
            }
            case "existing_rows_count": {
                return this.existingRowsCount();
            }
            case "deleted_rows_count": {
                return this.deletedRowsCount();
            }
            case "partitions": {
                return null;
            }
            case "key_metadata": {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown field '" + field + "'");
    }
}

