/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.attributerepo.featues.crypto;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.polyglotted.attributerepo.features.AbstractFeatureProvider;
import org.polyglotted.attributerepo.features.FeatureRegistry;
import org.polyglotted.crypto.asymmetric.RsaDecrypter;
import org.polyglotted.crypto.asymmetric.RsaKeyReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class RsaCryptoProvider
extends AbstractFeatureProvider {
    private RsaDecrypter rsaDecrypter;
    private String prefix;

    @Autowired
    public RsaCryptoProvider(FeatureRegistry featureRegistry) {
        super(featureRegistry);
    }

    public boolean canResolve(String string) {
        return string.startsWith(this.prefix);
    }

    public String resolveAttribute(String string, Properties properties) {
        return this.rsaDecrypter.crypt(properties.getProperty(string));
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setPrivateKey(Resource resource) throws IOException {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((boolean)resource.isReadable());
        this.rsaDecrypter = new RsaDecrypter(RsaKeyReader.readPrivateKey((InputStream)resource.getInputStream()));
    }
}

