/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.attributerepo.featues.crypto;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.polyglotted.attributerepo.features.AbstractFeatureProvider;
import org.polyglotted.attributerepo.features.FeatureRegistry;
import org.polyglotted.crypto.symmetric.AesDecrypter;
import org.springframework.beans.factory.annotation.Autowired;

public class AesCryptoProvider
extends AbstractFeatureProvider {
    private AesDecrypter aesDecrypter;
    private String prefix;

    @Autowired
    public AesCryptoProvider(FeatureRegistry featureRegistry) {
        super(featureRegistry);
    }

    public boolean canResolve(String string) {
        return string.startsWith(this.prefix);
    }

    public String resolveAttribute(String string, Properties properties) {
        return this.aesDecrypter.crypt(properties.getProperty(string));
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setPassphrase(String string) {
        Preconditions.checkNotNull((Object)string);
        this.aesDecrypter = new AesDecrypter(string);
    }
}

