/*
 * Decompiled with CFR 0.152.
 */
package org.helm.chemtoolkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.helm.chemtoolkit.AbstractMolecule;
import org.helm.chemtoolkit.Attachment;
import org.helm.chemtoolkit.AttachmentList;
import org.helm.chemtoolkit.CTKException;
import org.helm.chemtoolkit.CTKSmilesException;
import org.helm.chemtoolkit.IAtomBase;
import org.helm.chemtoolkit.IBondBase;
import org.helm.chemtoolkit.IStereoElementBase;
import org.helm.chemtoolkit.MoleculeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChemistryManipulator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractChemistryManipulator.class);
    protected static final String SMILES_EXTENSION_SEPARATOR_REGEX = "\\|";

    public abstract String convertMolecule(AbstractMolecule var1, StType var2) throws CTKException;

    public abstract String convert(String var1, StType var2) throws CTKException;

    public String convertExtendedSmiles(String data) {
        Pattern pattern;
        Matcher matcher;
        if (data != null && (matcher = (pattern = Pattern.compile("\\[\\*\\]")).matcher(data)) != null) {
            String smiles = data.split(SMILES_EXTENSION_SEPARATOR_REGEX)[0];
            List<Integer> rgroupInformation = this.extractRgroups(data);
            StringBuilder sb = new StringBuilder();
            int start = 0;
            int index = 0;
            String rGroup = "";
            while (matcher.find() && rgroupInformation.size() > 0) {
                rGroup = smiles.substring(start, matcher.end());
                rGroup = rGroup.replace(matcher.group(), "[*:" + rgroupInformation.get(index) + "]");
                sb.append(rGroup);
                ++index;
                start = matcher.end();
            }
            if (start < smiles.length()) {
                sb.append(smiles.substring(start));
            }
            return sb.toString();
        }
        return data;
    }

    private List<Integer> extractRgroups(String data) {
        Pattern pattern = Pattern.compile("R[1-9]\\d*");
        Matcher matcher = pattern.matcher(data);
        ArrayList<Integer> listValues = new ArrayList<Integer>();
        while (matcher.find()) {
            listValues.add(Integer.parseInt(matcher.group().split("R")[1]));
        }
        return listValues;
    }

    public abstract boolean validateSMILES(String var1);

    public abstract MoleculeInfo getMoleculeInfo(AbstractMolecule var1) throws CTKException;

    public abstract String canonicalize(String var1) throws CTKException, CTKSmilesException;

    public abstract byte[] renderMol(String var1, OutputType var2, int var3, int var4, int var5) throws CTKException;

    public abstract byte[] renderSequence(String var1, OutputType var2, int var3, int var4, int var5) throws CTKException;

    public abstract AbstractMolecule getMolecule(String var1, AttachmentList var2) throws IOException, CTKException;

    public AbstractMolecule merge(AbstractMolecule firstContainer, IAtomBase firstRgroup, AbstractMolecule secondContainer, IAtomBase secondRgroup) throws CTKException {
        if (firstContainer.isSingleStereo(firstRgroup) && secondContainer.isSingleStereo(secondRgroup)) {
            throw new CTKException("Both R atoms are connected to chiral centers");
        }
        if (firstContainer == secondContainer) {
            firstContainer.dearomatize();
            secondContainer.dearomatize();
            IAtomBase atom1 = this.getNeighborAtom(firstRgroup);
            IAtomBase atom2 = this.getNeighborAtom(secondRgroup);
            firstContainer.removeAttachment(firstRgroup);
            firstContainer.removeAttachment(secondRgroup);
            this.setStereoInformation(firstContainer, firstRgroup, firstContainer, secondRgroup, atom1, atom2);
            firstContainer.removeINode(firstRgroup);
            firstContainer.removeINode(secondRgroup);
        } else {
            firstContainer.dearomatize();
            secondContainer.dearomatize();
            IAtomBase atom1 = this.getNeighborAtom(firstRgroup);
            IAtomBase atom2 = this.getNeighborAtom(secondRgroup);
            firstContainer.removeAttachment(firstRgroup);
            secondContainer.removeAttachment(secondRgroup);
            this.setStereoInformation(firstContainer, firstRgroup, secondContainer, secondRgroup, atom1, atom2);
            firstContainer.removeINode(firstRgroup);
            secondContainer.removeINode(secondRgroup);
            AttachmentList mergedAttachments = this.mergeAttachments(firstContainer, secondContainer);
            firstContainer.addIBase(secondContainer);
            firstContainer.setAttachments(mergedAttachments);
        }
        return firstContainer;
    }

    protected boolean setStereoInformation(AbstractMolecule firstContainer, IAtomBase firstRgroup, AbstractMolecule secondContainer, IAtomBase secondRgroup, IAtomBase atom1, IAtomBase atom2) throws CTKException {
        IStereoElementBase stereo = null;
        boolean result = false;
        if (firstContainer.isSingleStereo(firstRgroup)) {
            stereo = this.getStereoInformation(firstContainer, firstRgroup, atom2, atom1);
        }
        if (secondContainer.isSingleStereo(secondRgroup)) {
            stereo = this.getStereoInformation(secondContainer, secondRgroup, atom1, atom2);
        }
        if (stereo != null) {
            firstContainer.addIBase(stereo);
            result = true;
        }
        return result;
    }

    protected List<String> getRGroupsFromExtendedSmiles(String smiles) {
        String extendedSmiles = this.getExtension(smiles);
        ArrayList<String> list = new ArrayList<String>();
        if (extendedSmiles != null) {
            Integer n;
            Integer currIndex = 0;
            char[] items = extendedSmiles.toCharArray();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            while (extendedSmiles.indexOf("_R", (int)currIndex) > 0) {
                currIndex = extendedSmiles.indexOf("_R", (int)currIndex);
                indexes.add(currIndex);
                Integer n2 = currIndex;
                n = currIndex = Integer.valueOf(currIndex + 1);
            }
            for (int k = 0; k < items.length; ++k) {
                if (items[k] != 'R') continue;
                indexes.add(currIndex + k);
                n = currIndex;
                Integer n3 = currIndex = Integer.valueOf(currIndex + 1);
            }
            String[] tokens = extendedSmiles.split("R", -1);
            if (tokens.length > 1) {
                for (int i = 1; i < tokens.length; ++i) {
                    String letter;
                    String token = tokens[i];
                    char[] chars = token.toCharArray();
                    String numbers = "";
                    for (int j = 0; j < chars.length && (letter = String.valueOf(chars[j])).matches("[0-9]"); ++j) {
                        numbers = numbers + letter;
                    }
                    if (numbers.length() <= 0) continue;
                    list.add("R" + numbers);
                }
            }
        }
        if (extendedSmiles == null) {
            Pattern pattern = Pattern.compile("\\[\\*:([1-9]\\d*)\\]|\\[\\w+:([1-9]\\d*)");
            Matcher matcher = pattern.matcher(smiles);
            while (matcher.find()) {
                String info = "";
                if (matcher.group(1) != null) {
                    info = matcher.group(1);
                }
                if (matcher.group(2) != null) {
                    info = matcher.group(2);
                }
                list.add("R" + info);
            }
        }
        return list;
    }

    protected IAtomBase getNeighborAtom(IAtomBase rgroup) throws CTKException {
        IAtomBase atom = null;
        if (rgroup.getIBondCount() == 1) {
            IBondBase bond = rgroup.getIBond(0);
            atom = bond.getIAtom1().compare(rgroup) ? bond.getIAtom2() : bond.getIAtom1();
        }
        return atom;
    }

    protected String getExtension(String smiles) {
        String result = null;
        try {
            String[] components = smiles.split(SMILES_EXTENSION_SEPARATOR_REGEX);
            result = components[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    protected abstract IBondBase bindAtoms(IAtomBase var1, IAtomBase var2) throws CTKException;

    protected AttachmentList mergeAttachments(AbstractMolecule container, AbstractMolecule secondContainer) throws CTKException {
        Attachment a;
        AttachmentList result = new AttachmentList();
        int index = 1;
        for (Attachment item : container.getAttachments()) {
            a = item.cloneAttachment();
            container.changeAtomLabel(a.getCurrentIndex(), index);
            a.changeIndex(index);
            result.add(a);
            ++index;
        }
        for (Attachment item : secondContainer.getAttachments()) {
            a = item.cloneAttachment();
            secondContainer.changeAtomLabel(a.getCurrentIndex(), index);
            a.changeIndex(index);
            result.add(a);
            ++index;
        }
        container.clearFlags();
        secondContainer.clearFlags();
        return result;
    }

    protected abstract IStereoElementBase getStereoInformation(AbstractMolecule var1, IAtomBase var2, IAtomBase var3, IAtomBase var4) throws CTKException;

    public static enum OutputType {
        PNG("PNG"),
        GIF("GIF"),
        JPG("JPG");

        private final String value;

        private OutputType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum StType {
        SMILES,
        MOLFILE,
        SEQUENCE;

    }
}

