/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.helm.notation2.parser.exceptionparser.NotationException;
import org.helm.notation2.parser.notation.connection.ConnectionNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;
import org.helm.notation2.parser.notation.polymer.MonomerNotationUnitRNA;
import org.helm.notation2.parser.notation.polymer.PolymerNotation;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Graph;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoleculeGraphUtils {
    private static Map<String, Integer> polymerIDMap = new HashMap<String, Integer>();
    private static List<Integer> polymerIDList = new ArrayList<Integer>();
    private static final Logger LOG = LoggerFactory.getLogger(MoleculeGraphUtils.class);

    public static Graph buildMoleculeGraph(List<PolymerNotation> listPolymerNotations, List<ConnectionNotation> listOfConnections) throws NotationException {
        Graph moleculeGraph = new Graph();
        LOG.debug("Building molecule graph...");
        for (int idx = 0; idx < listPolymerNotations.size(); ++idx) {
            if (((MonomerNotation)listPolymerNotations.get(idx).getListMonomers().get(0)).getType().equalsIgnoreCase("RNA")) {
                moleculeGraph.addAllVertices(MoleculeGraphUtils.buildRNAPart(listPolymerNotations.get(idx), idx));
            } else if (((MonomerNotation)listPolymerNotations.get(idx).getListMonomers().get(0)).getType().equalsIgnoreCase("PEPTIDE")) {
                moleculeGraph.addAllVertices(MoleculeGraphUtils.buildPeptidePart(listPolymerNotations.get(idx), idx));
            } else if (((MonomerNotation)listPolymerNotations.get(idx).getListMonomers().get(0)).getType().equalsIgnoreCase("CHEM")) {
                moleculeGraph.addAllVertices(MoleculeGraphUtils.buildChemPart(listPolymerNotations.get(idx), idx));
            }
            polymerIDMap.put(listPolymerNotations.get(idx).getPolymerID().toString(), idx);
        }
        for (int vertexIdx = 0; vertexIdx < moleculeGraph.getVertices().size(); ++vertexIdx) {
            moleculeGraph.getVertices().get(vertexIdx).setIndex(vertexIdx);
        }
        if (!listOfConnections.isEmpty()) {
            moleculeGraph = MoleculeGraphUtils.addConnections(moleculeGraph, listPolymerNotations, listOfConnections);
        }
        polymerIDList.clear();
        polymerIDMap.clear();
        return moleculeGraph;
    }

    public static Graph buildRNAPart(PolymerNotation polymer, int polymerNumber) throws NotationException {
        Graph moleculeGraph = new Graph();
        ArrayList monomerUnitTypes = new ArrayList();
        LOG.debug("Building RNA part of molecule graph.");
        for (int n = 0; n < polymer.getListMonomers().size(); ++n) {
            MonomerNotationUnitRNA unit = new MonomerNotationUnitRNA(((MonomerNotation)polymer.getListMonomers().get(n)).getUnit(), "RNA");
            for (int m = 0; m < unit.getContents().size(); ++m) {
                moleculeGraph.addVertex((MonomerNotation)unit.getContents().get(m));
                Vertex lastAdded = moleculeGraph.getVertices().get(moleculeGraph.getVertices().size() - 1);
                lastAdded.monomerType = Vertex.Type.RNA;
                if (lastAdded.getMonomer().getUnit().length() > 1) {
                    lastAdded.setNonNatural();
                } else {
                    lastAdded.setHasUniqueUnit(true);
                }
                monomerUnitTypes.add(unit.getInformation().get(m));
                polymerIDList.add(polymerNumber);
            }
        }
        for (int i = 0; i < moleculeGraph.vertexCount() - 1; ++i) {
            String typeSecond;
            Vertex secondVertex;
            Vertex currentVertex = moleculeGraph.getVertices().get(i);
            String typeCurrent = (String)monomerUnitTypes.get(i);
            if (typeCurrent.equalsIgnoreCase("R")) {
                secondVertex = moleculeGraph.getVertices().get(i + 1);
                typeSecond = (String)monomerUnitTypes.get(i + 1);
                if (typeSecond.equalsIgnoreCase("P")) {
                    currentVertex.addBothNeighbours(secondVertex);
                    continue;
                }
                if (!typeSecond.equalsIgnoreCase("X")) continue;
                currentVertex.addBothNeighbours(secondVertex);
                if (i + 2 >= moleculeGraph.vertexCount()) continue;
                Vertex thirdVertex = moleculeGraph.getVertices().get(i + 2);
                String typeThird = (String)monomerUnitTypes.get(i + 2);
                if (!typeThird.equalsIgnoreCase("P")) continue;
                currentVertex.addBothNeighbours(thirdVertex);
                continue;
            }
            if (!typeCurrent.equalsIgnoreCase("P")) continue;
            secondVertex = moleculeGraph.getVertices().get(i + 1);
            typeSecond = (String)monomerUnitTypes.get(i + 1);
            if (!typeSecond.equalsIgnoreCase("R")) continue;
            currentVertex.addBothNeighbours(secondVertex);
        }
        LOG.debug("Building RNA part of molecule graph successful.");
        return moleculeGraph;
    }

    public static Graph buildPeptidePart(PolymerNotation polymer, int polymerNumber) {
        Graph moleculeGraph = new Graph();
        LOG.debug("Building PEPTIDE part of molecule graph.");
        for (int l = 0; l < polymer.getListMonomers().size(); ++l) {
            moleculeGraph.addVertex((MonomerNotation)polymer.getListMonomers().get(l));
            Vertex lastAdded = moleculeGraph.getVertices().get(moleculeGraph.getVertices().size() - 1);
            lastAdded.monomerType = Vertex.Type.PEPTIDE;
            if (lastAdded.getMonomer().getUnit().length() > 1) {
                lastAdded.setNonNatural();
            }
            polymerIDList.add(polymerNumber);
        }
        for (int i = 0; i < moleculeGraph.vertexCount() - 1; ++i) {
            Vertex currentVertex = moleculeGraph.getVertices().get(i);
            Vertex nextVertex = moleculeGraph.getVertices().get(i + 1);
            currentVertex.addBothNeighbours(nextVertex);
        }
        LOG.debug("Building PEPTIDE part of molecule graph successful..");
        return moleculeGraph;
    }

    public static Graph buildChemPart(PolymerNotation polymer, int polymerNumber) {
        Graph moleculeGraph = new Graph();
        LOG.debug("Building CHEM part of molecule graph.");
        moleculeGraph.addVertex((MonomerNotation)polymer.getListMonomers().get(0));
        moleculeGraph.getVertices().get((int)0).monomerType = Vertex.Type.CHEM;
        polymerIDList.add(polymerNumber);
        LOG.debug("Building CHEM part of molecule graph successful.");
        return moleculeGraph;
    }

    public static Graph addConnections(Graph moleculeGraph, List<PolymerNotation> polymerList, List<ConnectionNotation> listOfConnections) {
        LOG.debug("Adding connections to molecule graph.");
        for (int index = 0; index < listOfConnections.size(); ++index) {
            ConnectionNotation connection = listOfConnections.get(index);
            if (connection.getSourceId().toString().equals(connection.getTargetId().toString())) {
                LOG.debug("Adding connection between monomers of same polymer.");
                String polymerID = connection.getSourceId().toString();
                Integer polymerIdx = polymerIDMap.get(polymerID);
                int idxi = 0;
                int idxj = 0;
                if (polymerIdx == 0) {
                    idxi = Integer.parseInt(connection.getSourceUnit()) - 1;
                    idxj = Integer.parseInt(connection.getTargetUnit()) - 1;
                } else if (polymerIdx > 0) {
                    for (int polymerNumber = 0; polymerNumber < polymerIdx; ++polymerNumber) {
                        idxi += polymerList.get(polymerNumber).getListMonomers().size();
                    }
                    idxj = idxi + Integer.parseInt(connection.getTargetUnit()) - 1;
                    idxi += Integer.parseInt(connection.getSourceUnit()) - 1;
                }
                Vertex leftVertex = moleculeGraph.getVertices().get(idxi);
                Vertex rightVertex = moleculeGraph.getVertices().get(idxj);
                leftVertex.addBothNeighbours(rightVertex);
                LOG.debug("Adding connection between monomers of same polymer successful.");
                continue;
            }
            LOG.debug("Adding connection between monomers of different polymers.");
            String polymerID1 = connection.getSourceId().toString();
            String polymerID2 = connection.getTargetId().toString();
            Integer polymerIdx1 = polymerIDMap.get(polymerID1);
            Integer polymerIdx2 = polymerIDMap.get(polymerID2);
            int idxii = 0;
            if (polymerIdx1 == 0) {
                idxii = Integer.parseInt(connection.getSourceUnit()) - 1;
            } else if (polymerIdx1 > 0) {
                for (int polymerNumber = 0; polymerNumber < moleculeGraph.vertexCount() && polymerIDList.get(polymerNumber) != polymerIdx1; ++polymerNumber) {
                    ++idxii;
                }
                idxii += Integer.parseInt(connection.getSourceUnit()) - 1;
            }
            int idxjj = 0;
            if (polymerIdx2 == 0) {
                idxjj = Integer.parseInt(connection.getTargetUnit()) - 1;
            } else if (polymerIdx2 > 0) {
                for (int polymerNumber2 = 0; polymerNumber2 < moleculeGraph.vertexCount() && polymerIDList.get(polymerNumber2) != polymerIdx2; ++polymerNumber2) {
                    ++idxjj;
                }
                idxjj += Integer.parseInt(connection.getTargetUnit()) - 1;
            }
            Vertex leftVertex = moleculeGraph.getVertices().get(idxii);
            Vertex rightVertex = moleculeGraph.getVertices().get(idxjj);
            leftVertex.addBothNeighbours(rightVertex);
            LOG.debug("Adding connection between monomers of different polymers successful.");
        }
        LOG.debug("Adding connections to molecule graph successful.");
        return moleculeGraph;
    }
}

