/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.ExportTask;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Main;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.ResultUnit;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyButton;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyTableColumn;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyText;

public class Results
extends Main {
    protected MyText title;
    private static TableView<ResultUnit> resultNotations;
    private static MyTableColumn<ResultUnit, Integer> ids;
    private static MyTableColumn<ResultUnit, String> notations;
    private static MyTableColumn<ResultUnit, String> tanimotoValues;
    protected static MyButton exportButton;
    protected static MyText infoText;

    public Results() {
        infoText.setFont(Font.font((String)"Calibri", (FontPosture)FontPosture.ITALIC, (double)12.0));
        this.title = new MyText("Results");
        resultNotations = new TableView();
        resultNotations.setMaxHeight(200.0);
        resultNotations.setMinWidth(675.0);
        resultNotations.setMaxWidth(675.0);
        resultNotations.getSelectionModel().setCellSelectionEnabled(true);
        resultNotations.setPlaceholder((Node)new Label(""));
        ids = new MyTableColumn("ID", 50.0, "id");
        ids.setMaxWidth(50.0);
        notations = new MyTableColumn("HELM", 552.0, "helmNotation");
        tanimotoValues = new MyTableColumn("Similarity", 70.0, "tanimotoValue");
        exportButton = new MyButton("Export results to textfile");
        exportButton.setDisable(true);
        this.exportButtonAction();
    }

    public static void doResults(List<Map<String, Object>> resultMapList) {
        resultNotations.setItems(Results.getResultsAsObservableList(resultMapList));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Results.getResultNotations().getColumns().clear();
                resultNotations.getColumns().addAll((Object[])new TableColumn[]{ids, notations, tanimotoValues});
            }
        });
        resultNotations.setEditable(false);
        Results.enableCopyAction();
        Results.enableHelmTooltip();
    }

    private static ObservableList<ResultUnit> getResultsAsObservableList(List<Map<String, Object>> resultMapList) {
        ObservableList resultDataset = FXCollections.observableArrayList();
        resultMapList.forEach(listEntry -> {
            int id = (Integer)listEntry.get("ID");
            String helm = (String)listEntry.get("HELM");
            double tanimoto = (Double)listEntry.get("Similarity");
            resultDataset.add((Object)new ResultUnit(id, helm, tanimoto));
        });
        return resultDataset;
    }

    private static void enableCopyAction() {
        ContextMenu copyContext = new ContextMenu();
        MenuItem copyMenuItem = new MenuItem("Copy");
        copyContext.getItems().add((Object)copyMenuItem);
        copyMenuItem.setOnAction(copyEvent -> {
            ObservableList selectedCells = resultNotations.getSelectionModel().getSelectedCells();
            ResultUnit selectedItem = (ResultUnit)resultNotations.getSelectionModel().getSelectedItem();
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent copiedContent = new ClipboardContent();
            if (((TablePosition)selectedCells.get(0)).getColumn() == 0) {
                copiedContent.putString(selectedItem.getId().toString());
            } else if (((TablePosition)selectedCells.get(0)).getColumn() == 1) {
                copiedContent.putString(selectedItem.getHelmNotation());
            } else if (((TablePosition)selectedCells.get(0)).getColumn() == 2) {
                copiedContent.putString(selectedItem.getTanimotoValue().toString());
            }
            clipboard.setContent((Map)copiedContent);
        });
        resultNotations.setContextMenu(copyContext);
    }

    private static void enableHelmTooltip() {
        resultNotations.setRowFactory(table -> new TableRow<ResultUnit>(){
            private Tooltip helmTooltip = new Tooltip();

            public void updateItem(ResultUnit unit, boolean empty) {
                super.updateItem((Object)unit, empty);
                if (unit == null) {
                    this.setTooltip(null);
                } else {
                    this.helmTooltip.setText(unit.getHelmNotation());
                    this.setTooltip(this.helmTooltip);
                }
            }
        });
    }

    private void exportButtonAction() {
        exportButton.setOnAction(exportEvent -> {
            ExportTask expTask = new ExportTask();
            new Thread((Runnable)((Object)expTask)).start();
        });
    }

    public static void changeInfoText(String text) {
        infoText.setText(text);
    }

    public static TableView<ResultUnit> getResultNotations() {
        return resultNotations;
    }

    static {
        infoText = new MyText(true);
    }
}

