/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javafx.application.Platform;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Subset;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.CreateDatabaseTask;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;

public class Database {
    private static Database DatabaseObject = null;

    private Database() {
    }

    public static Database getInstance() {
        if (DatabaseObject == null) {
            DatabaseObject = new Database();
        }
        return DatabaseObject;
    }

    public void loadDriver(String drivername) throws ClassNotFoundException {
        Class.forName(drivername);
    }

    public void createTable(String url, String tableName, String column1, String column2) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        Statement stmt = con.createStatement();
        String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + column1 + " INT PRIMARY KEY," + column2 + "             TEXT)";
        stmt.executeUpdate(sql);
        stmt.close();
        con.close();
    }

    public void addColumn(String url, String tablename, String columnname) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        Statement stmt = con.createStatement();
        stmt.executeUpdate("ALTER TABLE " + tablename + " ADD COLUMN " + columnname);
        stmt.close();
        con.close();
    }

    public void deleteContentFromDB(String url) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        Statement stmt = con.createStatement();
        stmt.executeUpdate("DELETE FROM HELMnotations WHERE 1=1;");
        stmt.close();
        con.close();
    }

    public void fillHELMTable(String url, String infilename, CreateDatabaseTask createDatabase) throws SQLException, IOException {
        Connection con = DriverManager.getConnection(url);
        con.setAutoCommit(false);
        BufferedReader fileReader = new BufferedReader(new FileReader(infilename));
        Path path = Paths.get(infilename, new String[0]);
        boolean hasID = true;
        Pattern regExp = Pattern.compile("(\\d+)\\t(\\S+)|(\\S+)");
        String line = fileReader.readLine();
        Matcher m = regExp.matcher(line);
        int linecounter = 0;
        int id = 0;
        String helm = null;
        m.find();
        if (m.group(1) == null) {
            hasID = false;
        }
        long lineCount = 0L;
        try (Stream<String> stream = Files.lines(path);){
            lineCount = stream.count();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        while (line != null) {
            m = regExp.matcher(line);
            m.find();
            createDatabase.updateProgress(++linecounter, lineCount);
            if (hasID) {
                String idMatch = m.group(1);
                try {
                    id = Integer.parseInt(idMatch);
                    helm = m.group(2);
                }
                catch (Exception e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AlertBox.ErrorBox("Format Error", e.getMessage() + ". Please make sure you are using the correct file format. Only load textfiles with one HELM notation per line or one ID and one HELM notation separated by one tab per line.");
                        }
                    });
                }
            } else {
                id = linecounter;
                helm = m.group(3);
            }
            Statement stmt = con.createStatement();
            String sql = "INSERT INTO HELMnotations (ID, HELM) VALUES (" + id + ", '" + helm + "');";
            stmt.executeUpdate(sql);
            stmt.close();
            line = fileReader.readLine();
        }
        con.commit();
        Input.databaseNameDisplay.setText(Input.getDatabaseName() + " (" + Integer.toString(linecounter) + " entries)");
        con.close();
        fileReader.close();
    }

    public void insertFingerprints(String url, List<BitSet> fingerprints, List<BitSet> naturalFingerprints, List<Integer> idList, String tablename) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        con.setAutoCommit(false);
        PreparedStatement pStmt = con.prepareStatement("UPDATE " + tablename + " set OriginalFingerprint = ?, NaturalFingerprint = ? where ID = ?");
        for (int i = 0; i < fingerprints.size(); ++i) {
            pStmt.setString(1, fingerprints.get(i).toString());
            pStmt.setString(2, naturalFingerprints.get(i).toString());
            pStmt.setInt(3, idList.get(i));
            pStmt.executeUpdate();
        }
        con.commit();
        pStmt.close();
        con.close();
    }

    public void fillHELMTanimotoTable(String url, String tablename, List<Integer> idList, List<Double> tanimotoList) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        con.setAutoCommit(false);
        PreparedStatement pStmt = con.prepareStatement("UPDATE " + tablename + " SET Similarity = ? WHERE ID = ?;");
        for (int i = 0; i < tanimotoList.size(); ++i) {
            pStmt.setDouble(1, tanimotoList.get(i));
            pStmt.setInt(2, idList.get(i));
            pStmt.executeUpdate();
        }
        con.commit();
        pStmt.close();
        con.close();
    }

    public Map<Integer, String> readIDandHELMRecords(String url, String tablename) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        HashMap<Integer, String> idWithHELM = new HashMap<Integer, String>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ID, HELM FROM " + tablename + ";");
        while (rs.next()) {
            int id = rs.getInt("ID");
            idList.add(id);
            String helm = rs.getString("HELM");
            idWithHELM.put(id, helm);
        }
        rs.close();
        stmt.close();
        con.close();
        return idWithHELM;
    }

    public List<Map<String, Object>> getMostSimilarNotations(String url, String tablename, String columnname) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Statement stmt = con.createStatement();
        ResultSet resultNotations = stmt.executeQuery("SELECT * FROM " + tablename + " ORDER BY " + columnname + " DESC;");
        ResultSetMetaData metaData = resultNotations.getMetaData();
        Integer columnCount = metaData.getColumnCount();
        for (int notationCounter = 0; resultNotations.next() && notationCounter < 10; ++notationCounter) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                row.put(metaData.getColumnName(i), resultNotations.getObject(i));
            }
            resultList.add(row);
        }
        stmt.close();
        con.close();
        return resultList;
    }

    public List<Map<String, Object>> getNotationsWithSpecificTanimoto(String url, String tablename, String columnname, double desiredTanimoto) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Statement stmt = con.createStatement();
        ResultSet resultNotations = stmt.executeQuery("SELECT * FROM " + tablename + " WHERE " + columnname + " >= " + desiredTanimoto + " ORDER BY " + columnname + " DESC;");
        ResultSetMetaData metaData = resultNotations.getMetaData();
        Integer columnCount = metaData.getColumnCount();
        while (resultNotations.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                row.put(metaData.getColumnName(i), resultNotations.getObject(i));
            }
            resultList.add(row);
        }
        stmt.close();
        con.close();
        return resultList;
    }

    public List<Map<String, Object>> getNotationsWithSubset(String url, String tablename, String columnname) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Statement stmt = con.createStatement();
        ResultSet resultNotations = stmt.executeQuery("SELECT * FROM " + tablename + " WHERE " + columnname + " = 'true' ORDER BY Similarity DESC;");
        ResultSetMetaData metaData = resultNotations.getMetaData();
        Integer columnCount = metaData.getColumnCount();
        while (resultNotations.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                row.put(metaData.getColumnName(i), resultNotations.getObject(i));
            }
            resultList.add(row);
        }
        stmt.close();
        con.close();
        return resultList;
    }

    public void setSubset(String url, BitSet queryFingerprint, List<Integer> idList, List<BitSet> fingerprints) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        Statement stmt = con.createStatement();
        con.setAutoCommit(false);
        for (int idx = 0; idx < idList.size(); ++idx) {
            boolean hasSubset = Subset.checkHelmRelationship(queryFingerprint, fingerprints.get(idx));
            stmt.executeUpdate("UPDATE HELMnotations SET hasSubset = '" + hasSubset + "' WHERE ID = " + idList.get(idx));
        }
        con.commit();
        stmt.close();
        con.close();
    }

    public double getBiggestTanimoto(String url) throws SQLException {
        Connection con = DriverManager.getConnection(url);
        Statement stmt = con.createStatement();
        ResultSet result = stmt.executeQuery("SELECT MAX(Similarity) FROM HELMnotations");
        double biggestTanimoto = result.getDouble(1);
        stmt.close();
        result.close();
        con.close();
        return biggestTanimoto;
    }
}

