/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.IOException;
import java.sql.SQLException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Database;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;

public class CreateDatabaseTask
extends Task<Integer> {
    private Database dbInstance;

    public CreateDatabaseTask(Database dbInstance) {
        this.dbInstance = dbInstance;
    }

    protected Integer call() {
        try {
            String url = "jdbc:sqlite:" + Input.getDatabasePath();
            this.dbInstance.fillHELMTable(url, Input.getTextfilePath(), this);
        }
        catch (SQLException e) {
            this.updateUIerrorReport("SQLException", "Unable to fill database with ID and HELM: " + Input.getDatabasePath() + ".\n" + e.getMessage());
        }
        catch (IOException e) {
            this.updateUIerrorReport("IOException", "Unable to process textfile: " + Input.getTextfilePath() + ".\n" + e.getMessage());
        }
        return null;
    }

    protected void updateProgress(double workDone, double max) {
        super.updateProgress(workDone, max);
    }

    void updateUIerrorReport(final String errorType, final String content) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AlertBox.ErrorBox(errorType, content);
            }
        });
    }
}

