/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.utils;

import java.util.LinkedList;
import java.util.List;
import org.helm.notation2.parser.notation.polymer.MonomerNotation;

public class Vertex {
    private MonomerNotation monomer;
    private List<Vertex> neighbourList;
    private boolean isVisited;
    public Type monomerType;
    private boolean isNonNatural;
    private boolean hasUniqueUnit;
    private Vertex parent;
    private int index;

    public Vertex() {
        this.neighbourList = new LinkedList<Vertex>();
    }

    public Vertex(Vertex vertex) {
        this.monomer = vertex.getMonomer();
        this.neighbourList = vertex.getNeighbourList();
        this.isVisited = vertex.isVisited;
        this.isNonNatural = vertex.isNonNatural;
        this.hasUniqueUnit = vertex.hasUniqueUnit;
        this.parent = vertex.parent;
        this.index = vertex.index;
        this.monomerType = vertex.monomerType;
    }

    public Vertex(Vertex vertex, Type monomerType) {
        this.monomer = vertex.getMonomer();
        this.neighbourList = vertex.getNeighbourList();
        this.isVisited = vertex.isVisited;
        this.isNonNatural = vertex.isNonNatural;
        this.hasUniqueUnit = vertex.hasUniqueUnit;
        this.parent = vertex.parent;
        this.index = vertex.index;
        this.monomerType = monomerType;
    }

    public Vertex(MonomerNotation monomer) {
        this.monomer = monomer;
        this.neighbourList = new LinkedList<Vertex>();
    }

    public Vertex(MonomerNotation monomer, Type monomerType, boolean isNonNatural, boolean hasUniqueUnit, int index) {
        this.monomer = monomer;
        this.isNonNatural = isNonNatural;
        this.index = index;
        this.monomerType = monomerType;
        this.neighbourList = new LinkedList<Vertex>();
        this.hasUniqueUnit = hasUniqueUnit;
    }

    public MonomerNotation getMonomer() {
        return this.monomer;
    }

    public void addNeighbour(Vertex vertex) {
        this.neighbourList.add(vertex);
    }

    public void addBothNeighbours(Vertex vertex) {
        this.neighbourList.add(vertex);
        vertex.neighbourList.add(this);
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean visited) {
        this.isVisited = visited;
    }

    public void setMonomer(MonomerNotation monomer) {
        this.monomer = monomer;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public int getIndex() {
        return this.index;
    }

    public List<Vertex> getNeighbourList() {
        return this.neighbourList;
    }

    public void setNeighbourList(List<Vertex> neighbourList) {
        this.neighbourList = neighbourList;
    }

    public Vertex getParent() {
        return this.parent;
    }

    public void setParent(Vertex parent) {
        this.parent = parent;
    }

    public boolean isPeptide() {
        return this.monomerType == Type.PEPTIDE;
    }

    public boolean isRNA() {
        return this.monomerType == Type.RNA;
    }

    public boolean isChem() {
        return this.monomerType == Type.CHEM;
    }

    public boolean isNonNatural() {
        return this.isNonNatural;
    }

    public void setNonNatural() {
        this.isNonNatural = true;
    }

    public boolean hasUniqueUnit() {
        return this.hasUniqueUnit;
    }

    public void setHasUniqueUnit(boolean hasUniqueUnit) {
        this.hasUniqueUnit = hasUniqueUnit;
    }

    public String toString() {
        return this.monomer.getUnit();
    }

    public boolean equals(Vertex otherVertex) {
        if (this.isRNA() != otherVertex.isRNA()) {
            return false;
        }
        if (this.isPeptide() != otherVertex.isPeptide()) {
            return false;
        }
        if (this.isChem() != otherVertex.isChem()) {
            return false;
        }
        if (this.isNonNatural != otherVertex.isNonNatural) {
            return false;
        }
        return this.monomerEqual(otherVertex.monomer);
    }

    private boolean monomerEqual(MonomerNotation monomer2) {
        if (!this.monomer.getUnit().equals(monomer2.getUnit())) {
            return false;
        }
        if (!this.monomer.getCount().equals(monomer2.getCount())) {
            return false;
        }
        return this.monomer.getType().equals(monomer2.getType());
    }

    public static enum Type {
        PEPTIDE,
        RNA,
        CHEM;

    }
}

