/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.io.FilenameUtils;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.FileToDatabase;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Main;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Options;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.AlertBox;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyButton;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyLabel;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyText;

public class Input
extends Main {
    protected MyLabel inputTitle = new MyLabel("Data input");
    protected MyButton helpButton = new MyButton("?");
    protected MyText textfileText;
    protected MyText databaseText;
    protected MyButton textfileButton;
    protected MyButton buildDatabaseButton;
    protected MyText textfileNameDisplay;
    protected static MyText databaseNameDisplay;
    private String defaultFileName = "No file selected.";
    private FileChooser textfileChooser;
    private static String textfilePath;
    private static String textfileName;
    private static String databaseDirPath;
    private static String databasePath;
    private static String databaseName;

    public Input(Stage stage) {
        this.helpButton.setOnAction(this);
        this.textfileText = new MyText("Select a textfile with HELM notations: ");
        this.databaseText = new MyText("Build database from text file: ");
        this.textfileButton = new MyButton("Choose file...");
        this.textfileButton.setMinWidth(88.0);
        this.buildDatabaseButton = new MyButton("Build database");
        this.textfileNameDisplay = new MyText(this.defaultFileName);
        databaseNameDisplay = new MyText(this.defaultFileName);
        this.textfileChooser = new FileChooser();
        this.setFileChooserProperties(this.textfileChooser, "TXT", "*.txt", "Input textfile");
        this.getTextfilePath(stage);
        this.getDatabaseDirectory(stage);
    }

    private void setFileChooserProperties(FileChooser chooser, String fileIdentifier, String fileExtension, String title) {
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(fileIdentifier, new String[]{fileExtension}));
        chooser.setTitle(title);
    }

    private void getTextfilePath(Stage stage) {
        this.textfileButton.setOnAction(buttonEvent -> {
            File textfile = this.textfileChooser.showOpenDialog((Window)stage);
            if (textfile != null) {
                textfilePath = textfile.getPath();
                databaseDirPath = textfile.getParentFile().getPath();
                textfileName = textfile.getName();
                this.textfileNameDisplay.setText(textfileName);
            }
        });
    }

    private void getDatabaseDirectory(Stage stage) {
        this.buildDatabaseButton.setOnAction(buttonEvent -> {
            if (textfileName == null) {
                AlertBox.ErrorBox("File Error", "Please select a textfile.");
            } else {
                databaseNameDisplay.setText("");
                String rawfileName = FilenameUtils.getBaseName((String)textfileName);
                databasePath = databaseDirPath + "/" + rawfileName + ".db";
                databaseName = rawfileName + ".db";
                FileToDatabase.processTextFile(databaseDirPath);
                this.textfileButton.setDisable(true);
                this.buildDatabaseButton.setDisable(true);
                Options.button.setDisable(false);
            }
        });
    }

    @Override
    public void handle(ActionEvent event) {
        if (event.getSource() == this.helpButton) {
            AlertBox.HelpBox("The notations will be stored in a SQLite database. Please note that the textfile must contain one ID and one HELM notation per line separated by a tab. If the textfile contains HELM notations without ID, the IDs will be generated automatically.\n\n");
        }
    }

    public static String getTextfilePath() {
        return textfilePath;
    }

    public static String getTextfileName() {
        return textfileName;
    }

    public static String getDatabaseDirPath() {
        return databaseDirPath;
    }

    public static String getDatabasePath() {
        return databasePath;
    }

    public static String getDatabaseName() {
        return databaseName;
    }

    public static void setTextfilePath(String path) {
        textfilePath = path;
    }

    public static void setTextfileName(String name) {
        textfileName = name;
    }

    public static void setDatabaseDirPath(String path) {
        databaseDirPath = path;
    }

    public static void setDatabasePath(String path) {
        databasePath = path;
    }

    public static void setDatabaseName(String name) {
        databaseName = name;
    }
}

