/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary;

import java.util.BitSet;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Fingerprinter;

public class Similarity {
    public static double calculateSimilarity(HELM2Notation notation1, HELM2Notation notation2) throws Exception {
        BitSet fingerprint1 = Fingerprinter.calculateFingerprint(notation1);
        BitSet fingerprint2 = Fingerprinter.calculateFingerprint(notation2);
        return Similarity.calculateSimilarity(fingerprint1, fingerprint2);
    }

    public static double calculateSimilarityNatAnalogs(HELM2Notation notation1, HELM2Notation notation2) throws Exception {
        BitSet fingerprint1 = Fingerprinter.calculateFingerprintNaturalAnalogs(notation1);
        BitSet fingerprint2 = Fingerprinter.calculateFingerprintNaturalAnalogs(notation2);
        return Similarity.calculateSimilarity(fingerprint1, fingerprint2);
    }

    public static double calculateSimilarity(BitSet helmBitFingerprintI, BitSet helmBitFingerprintJ) {
        BitSet resultHELMFingerprint = (BitSet)helmBitFingerprintI.clone();
        resultHELMFingerprint.and(helmBitFingerprintJ);
        double denominator = helmBitFingerprintI.cardinality() + helmBitFingerprintJ.cardinality() - resultHELMFingerprint.cardinality();
        return (double)resultHELMFingerprint.cardinality() / denominator;
    }
}

