/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.MonomerStore;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.exception.NaturalAnalogException;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Graph;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathGenerator {
    private static int searchDepth = 6;
    public static Set<String> totalPaths;
    public static Set<String> totalNaturalPaths;
    private static Map<String, Map<String, Monomer>> monStore;
    final Logger LOG = LoggerFactory.getLogger(PathGenerator.class);

    public PathGenerator() {
        totalPaths = new HashSet<String>();
        totalNaturalPaths = new HashSet<String>();
        try {
            MonomerStore store = MonomerFactory.getInstance().getMonomerStore();
            monStore = store.getMonomerDB();
        }
        catch (MonomerLoadingException e) {
            e.printStackTrace();
        }
        catch (ChemistryException e) {
            e.printStackTrace();
        }
    }

    public void findPaths(Graph moleculeGraph) throws NaturalAnalogException {
        int numOfMonomers = moleculeGraph.getVertices().size();
        for (int i = 0; i < numOfMonomers; ++i) {
            Vertex rootVertex = new Vertex(moleculeGraph.getVertices().get(i));
            String monomerUnit = rootVertex.getMonomer().getUnit();
            String naturalAnalog = "";
            ArrayList<String> currentOrigPathList = new ArrayList<String>();
            ArrayList<String> currentNatPathList = new ArrayList<String>();
            if (rootVertex.hasUniqueUnit()) {
                monomerUnit = monomerUnit.toLowerCase();
            }
            String currentOrigPath = monomerUnit;
            currentOrigPathList.add(monomerUnit);
            if (rootVertex.isNonNatural()) {
                monomerUnit = monomerUnit.substring(1, monomerUnit.length() - 1);
                if (rootVertex.isPeptide()) {
                    naturalAnalog = this.getNaturalPeptide(monomerUnit);
                }
                if (rootVertex.isRNA()) {
                    naturalAnalog = this.getNaturalRNA(monomerUnit);
                }
                if (rootVertex.isChem()) {
                    naturalAnalog = rootVertex.getMonomer().getUnit();
                }
            } else {
                naturalAnalog = rootVertex.hasUniqueUnit() ? rootVertex.getMonomer().getUnit().toLowerCase() : rootVertex.getMonomer().getUnit();
            }
            String currentNatPath = naturalAnalog;
            currentNatPathList.add(currentNatPath);
            PathGenerator.checkAndStorePath(currentOrigPath, currentOrigPathList, currentNatPath, currentNatPathList);
            ArrayList<Boolean> visited = new ArrayList<Boolean>(Arrays.asList(new Boolean[numOfMonomers]));
            this.depthFirstSearch(moleculeGraph, visited, i, currentOrigPath, currentOrigPathList, currentNatPath, currentNatPathList, 0);
        }
    }

    public static void checkAndStorePath(String newOrigPath, List<String> listNewOrigPath, String newNatPath, List<String> listNewNatPath) {
        LinkedList<String> listReverseOrigPath = new LinkedList<String>(listNewOrigPath);
        Collections.reverse(listReverseOrigPath);
        String reverseOrigPath = String.join((CharSequence)"", listReverseOrigPath);
        if (totalPaths.contains(reverseOrigPath)) {
            for (int i = 0; i < reverseOrigPath.length(); ++i) {
                if (reverseOrigPath.charAt(i) == newOrigPath.charAt(i)) continue;
                if (reverseOrigPath.charAt(i) >= newOrigPath.charAt(i)) {
                    totalPaths.remove(reverseOrigPath);
                    totalPaths.add(newOrigPath);
                }
                break;
            }
        } else {
            totalPaths.add(newOrigPath);
        }
        LinkedList<String> listReverseNatPath = new LinkedList<String>(listNewNatPath);
        Collections.reverse(listReverseNatPath);
        String reverseNatPath = String.join((CharSequence)"", listReverseNatPath);
        if (totalNaturalPaths.contains(reverseNatPath)) {
            for (int i = 0; i < reverseNatPath.length(); ++i) {
                if (reverseNatPath.charAt(i) == newNatPath.charAt(i)) continue;
                if (reverseNatPath.charAt(i) >= newNatPath.charAt(i)) {
                    totalNaturalPaths.remove(reverseNatPath);
                    totalNaturalPaths.add(newNatPath);
                }
                break;
            }
        } else {
            totalNaturalPaths.add(newNatPath);
        }
    }

    private void depthFirstSearch(Graph polymerGraph, List<Boolean> visited, int rootVertexIdx, String currentOrigPath, List<String> currentOrigPathList, String currentNatPath, List<String> currentNatPathList, int currentDepth) {
        ++currentDepth;
        Vertex rootVertex = new Vertex(polymerGraph.getVertices().get(rootVertexIdx));
        List<Vertex> neighbourVertices = rootVertex.getNeighbourList();
        for (int i = 0; i < neighbourVertices.size(); ++i) {
            if (currentDepth == 1) {
                Collections.fill(visited, false);
                visited.set(rootVertexIdx, true);
            }
            if (visited.get(neighbourVertices.get(i).getIndex()).booleanValue()) continue;
            Vertex neighbourVertex = new Vertex(neighbourVertices.get(i));
            String naturalAnalog = "";
            String monomerUnit = neighbourVertex.getMonomer().getUnit();
            if (neighbourVertex.hasUniqueUnit()) {
                monomerUnit = monomerUnit.toLowerCase();
            }
            String newOrigPath = currentOrigPath + monomerUnit;
            currentOrigPathList.add(monomerUnit);
            if (neighbourVertex.isNonNatural()) {
                monomerUnit = monomerUnit.substring(1, monomerUnit.length() - 1);
                if (neighbourVertex.isPeptide()) {
                    naturalAnalog = this.getNaturalPeptide(monomerUnit);
                } else if (neighbourVertex.isRNA()) {
                    naturalAnalog = this.getNaturalRNA(monomerUnit);
                } else if (neighbourVertex.isChem()) {
                    naturalAnalog = neighbourVertex.getMonomer().getUnit();
                }
            } else {
                naturalAnalog = neighbourVertex.hasUniqueUnit() ? neighbourVertex.getMonomer().getUnit().toLowerCase() : neighbourVertex.getMonomer().getUnit();
            }
            String newNatPath = currentNatPath + naturalAnalog;
            currentNatPathList.add(naturalAnalog);
            if (currentDepth < searchDepth) {
                PathGenerator.checkAndStorePath(newOrigPath, currentOrigPathList, newNatPath, currentNatPathList);
                visited.set(neighbourVertex.getIndex(), true);
                this.depthFirstSearch(polymerGraph, visited, neighbourVertex.getIndex(), newOrigPath, currentOrigPathList, newNatPath, currentNatPathList, currentDepth);
                visited.set(neighbourVertex.getIndex(), false);
                currentOrigPathList.remove(currentOrigPathList.size() - 1);
                currentNatPathList.remove(currentNatPathList.size() - 1);
                continue;
            }
            currentOrigPathList.remove(currentOrigPathList.size() - 1);
            currentNatPathList.remove(currentNatPathList.size() - 1);
        }
    }

    public String getNaturalPeptide(String monomerUnit) {
        for (Map.Entry<String, Map<String, Monomer>> polymerType : monStore.entrySet()) {
            if (!polymerType.getKey().equalsIgnoreCase("Peptide")) continue;
            Map<String, Monomer> peptideMap = polymerType.getValue();
            for (Map.Entry<String, Monomer> monomer : peptideMap.entrySet()) {
                if (!monomer.getValue().getAlternateId().equalsIgnoreCase(monomerUnit)) continue;
                return monomer.getValue().getNaturalAnalog();
            }
        }
        this.LOG.warn("Could not find natural analog to monomer");
        return "[" + monomerUnit + "]";
    }

    public String getNaturalRNA(String monomerUnit) {
        for (Map.Entry<String, Map<String, Monomer>> polymerType : monStore.entrySet()) {
            if (!polymerType.getKey().equalsIgnoreCase("RNA")) continue;
            Map<String, Monomer> rnaMap = polymerType.getValue();
            for (Map.Entry<String, Monomer> monomer : rnaMap.entrySet()) {
                if (!monomer.getValue().getAlternateId().equalsIgnoreCase(monomerUnit)) continue;
                return monomer.getValue().getNaturalAnalog().toLowerCase();
            }
        }
        this.LOG.warn("Could not find natural analog to monomer");
        return "[" + monomerUnit + "]";
    }

    public Set<String> getPaths() {
        return totalPaths;
    }

    public Set<String> getNaturalPaths() {
        return totalNaturalPaths;
    }

    public void clearPaths() {
        totalPaths.clear();
        totalNaturalPaths.clear();
    }
}

