/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.persistence.hibernate;

import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.picocontainer.Disposable;
import org.picocontainer.Startable;
import org.picocontainer.persistence.hibernate.AbstractSessionDecorator;

public final class ScopedSession
extends AbstractSessionDecorator
implements Startable,
Disposable {
    private final SessionFactory factory;
    private Session session = null;
    private Interceptor interceptor = null;
    private boolean disposed = false;

    public ScopedSession(SessionFactory factory) {
        this.factory = factory;
    }

    public ScopedSession(SessionFactory factory, Interceptor interceptor) {
        this(factory);
        this.setInterceptor(interceptor);
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public Session getDelegate() {
        if (this.disposed) {
            throw new IllegalStateException("Component has already been disposed by parent container.");
        }
        if (this.session == null) {
            try {
                this.session = this.interceptor == null ? this.factory.openSession() : this.factory.openSession(this.interceptor);
            }
            catch (RuntimeException ex) {
                throw this.handleException(ex);
            }
        }
        return this.session;
    }

    public Connection close() {
        try {
            Connection connection = this.getDelegate().close();
            return connection;
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
        finally {
            this.session = null;
        }
    }

    public void invalidateDelegate() {
        if (this.session != null) {
            try {
                this.session.clear();
                this.session.close();
            }
            catch (HibernateException ex) {
                throw this.handleException((RuntimeException)((Object)ex));
            }
            finally {
                this.session = null;
            }
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) throws IllegalStateException {
        if (this.session != null) {
            throw new IllegalStateException("Cannot apply interceptor after session has been utilized");
        }
        this.interceptor = interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public int hashCode() {
        if (this.session == null) {
            return 13;
        }
        return this.session.hashCode();
    }

    public String toString() {
        return ScopedSession.class.getName() + " using current Session : " + this.session;
    }

    public void start() {
    }

    public void stop() {
        this.close();
    }

    public void dispose() {
        if (this.session != null) {
            this.close();
        }
        this.disposed = true;
    }
}

