/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.persistence.hibernate;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.picocontainer.Disposable;
import org.picocontainer.PicoCompositionException;

public final class ConfigurableSessionFactory
implements SessionFactory,
Disposable {
    private final SessionFactory delegate;

    public ConfigurableSessionFactory(Configuration configuration) {
        try {
            this.delegate = configuration.buildSessionFactory();
        }
        catch (HibernateException e) {
            throw new PicoCompositionException((Throwable)e);
        }
    }

    public SessionFactory getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.delegate.close();
    }

    public void evict(Class persistentClass) {
        this.delegate.evict(persistentClass);
    }

    public void evict(Class persistentClass, Serializable id) {
        this.delegate.evict(persistentClass, id);
    }

    public void evictCollection(String roleName) {
        this.delegate.evictCollection(roleName);
    }

    public void evictCollection(String roleName, Serializable id) {
        this.delegate.evictCollection(roleName, id);
    }

    public void evictEntity(String entityName) {
        this.delegate.evictEntity(entityName);
    }

    public void evictEntity(String entityName, Serializable id) {
        this.delegate.evictEntity(entityName, id);
    }

    public void evictQueries() {
        this.delegate.evictQueries();
    }

    public void evictQueries(String cacheRegion) {
        this.delegate.evictQueries(cacheRegion);
    }

    public Map getAllClassMetadata() {
        return this.delegate.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.delegate.getAllCollectionMetadata();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) {
        return this.delegate.getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.delegate.getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.delegate.getCollectionMetadata(roleName);
    }

    public Session getCurrentSession() {
        return this.delegate.getCurrentSession();
    }

    public Set getDefinedFilterNames() {
        return this.delegate.getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.delegate.getFilterDefinition(filterName);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public Session openSession() {
        return this.delegate.openSession();
    }

    public Session openSession(Connection connection) {
        return this.delegate.openSession(connection);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.delegate.openSession(connection, interceptor);
    }

    public Session openSession(Interceptor interceptor) {
        return this.delegate.openSession(interceptor);
    }

    public StatelessSession openStatelessSession() {
        return this.delegate.openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.delegate.openStatelessSession(connection);
    }

    public void dispose() {
        this.close();
    }
}

