/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.persistence.hibernate;

import java.io.Serializable;
import java.sql.Connection;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.stat.SessionStatistics;

public abstract class AbstractSessionDecorator
implements Session {
    public abstract Session getDelegate();

    public abstract void invalidateDelegate();

    protected RuntimeException handleException(RuntimeException cause) {
        try {
            this.invalidateDelegate();
        }
        catch (RuntimeException e) {
            return e;
        }
        return cause;
    }

    public Transaction beginTransaction() {
        try {
            return this.getDelegate().beginTransaction();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void cancelQuery() {
        try {
            this.getDelegate().cancelQuery();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void clear() {
        try {
            this.getDelegate().clear();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Connection close() {
        try {
            return this.getDelegate().close();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    @Deprecated
    public Connection connection() {
        try {
            return this.getDelegate().connection();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public boolean contains(Object object) {
        try {
            return this.getDelegate().contains(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Criteria createCriteria(Class persistentClass) {
        try {
            return this.getDelegate().createCriteria(persistentClass);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        try {
            return this.getDelegate().createCriteria(persistentClass, alias);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Criteria createCriteria(String entityName) {
        try {
            return this.getDelegate().createCriteria(entityName);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Criteria createCriteria(String entityName, String alias) {
        try {
            return this.getDelegate().createCriteria(entityName, alias);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Query createFilter(Object collection, String queryString) {
        try {
            return this.getDelegate().createFilter(collection, queryString);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Query createQuery(String queryString) {
        try {
            return this.getDelegate().createQuery(queryString);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public SQLQuery createSQLQuery(String queryString) {
        try {
            return this.getDelegate().createSQLQuery(queryString);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void delete(Object object) {
        try {
            this.getDelegate().delete(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void delete(String entityName, Object object) {
        try {
            this.getDelegate().delete(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void disableFilter(String filterName) {
        try {
            this.getDelegate().disableFilter(filterName);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Connection disconnect() {
        try {
            return this.getDelegate().disconnect();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Filter enableFilter(String filterName) {
        try {
            return this.getDelegate().enableFilter(filterName);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void evict(Object object) {
        try {
            this.getDelegate().evict(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void flush() {
        try {
            this.getDelegate().flush();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object get(Class clazz, Serializable id) {
        try {
            return this.getDelegate().get(clazz, id);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) {
        try {
            return this.getDelegate().get(clazz, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object get(String entityName, Serializable id) {
        try {
            return this.getDelegate().get(entityName, id);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) {
        try {
            return this.getDelegate().get(entityName, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public CacheMode getCacheMode() {
        try {
            return this.getDelegate().getCacheMode();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public LockMode getCurrentLockMode(Object object) {
        try {
            return this.getDelegate().getCurrentLockMode(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Filter getEnabledFilter(String filterName) {
        try {
            return this.getDelegate().getEnabledFilter(filterName);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public EntityMode getEntityMode() {
        try {
            return this.getDelegate().getEntityMode();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public String getEntityName(Object object) {
        try {
            return this.getDelegate().getEntityName(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public FlushMode getFlushMode() {
        try {
            return this.getDelegate().getFlushMode();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Serializable getIdentifier(Object object) {
        try {
            return this.getDelegate().getIdentifier(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Query getNamedQuery(String queryName) {
        try {
            return this.getDelegate().getNamedQuery(queryName);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Session getSession(EntityMode entityMode) {
        try {
            return this.getDelegate().getSession(entityMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public SessionFactory getSessionFactory() {
        try {
            return this.getDelegate().getSessionFactory();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public SessionStatistics getStatistics() {
        try {
            return this.getDelegate().getStatistics();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Transaction getTransaction() {
        try {
            return this.getDelegate().getTransaction();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public boolean isConnected() {
        try {
            return this.getDelegate().isConnected();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public boolean isDirty() {
        try {
            return this.getDelegate().isDirty();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public boolean isOpen() {
        try {
            return this.getDelegate().isOpen();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object load(Class theClass, Serializable id) {
        try {
            return this.getDelegate().load(theClass, id);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) {
        try {
            return this.getDelegate().load(theClass, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void load(Object object, Serializable id) {
        try {
            this.getDelegate().load(object, id);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object load(String entityName, Serializable id) {
        try {
            return this.getDelegate().load(entityName, id);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) {
        try {
            return this.getDelegate().load(entityName, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void lock(Object object, LockMode lockMode) {
        try {
            this.getDelegate().lock(object, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void lock(String entityEntity, Object object, LockMode lockMode) {
        try {
            this.getDelegate().lock(entityEntity, object, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object merge(Object object) {
        try {
            return this.getDelegate().merge(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Object merge(String entityName, Object object) {
        try {
            return this.getDelegate().merge(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void persist(Object object) {
        try {
            this.getDelegate().persist(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void persist(String entityName, Object object) {
        try {
            this.getDelegate().persist(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    @Deprecated
    public void reconnect() {
        try {
            this.getDelegate().reconnect();
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void reconnect(Connection conn) {
        try {
            this.getDelegate().reconnect(conn);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void refresh(Object object) {
        try {
            this.getDelegate().refresh(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void refresh(Object object, LockMode lockMode) {
        try {
            this.getDelegate().refresh(object, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) {
        try {
            this.getDelegate().replicate(object, replicationMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) {
        try {
            this.getDelegate().replicate(entityName, object, replicationMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Serializable save(Object object) {
        try {
            return this.getDelegate().save(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public Serializable save(String entityName, Object object) {
        try {
            return this.getDelegate().save(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void saveOrUpdate(Object object) {
        try {
            this.getDelegate().saveOrUpdate(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void saveOrUpdate(String entityName, Object object) {
        try {
            this.getDelegate().saveOrUpdate(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void setCacheMode(CacheMode cacheMode) {
        try {
            this.getDelegate().setCacheMode(cacheMode);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        try {
            this.getDelegate().setReadOnly(entity, readOnly);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void setFlushMode(FlushMode value) {
        try {
            this.getDelegate().setFlushMode(value);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void update(Object object) {
        try {
            this.getDelegate().update(object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }

    public void update(String entityName, Object object) {
        try {
            this.getDelegate().update(entityName, object);
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
    }
}

