/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jwt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jwt.JWT;
import org.picketlink.json.util.JsonUtil;

public class JWTBuilder<T extends JWT, B extends JWTBuilder<?, ?>> {
    private final JsonObjectBuilder headersBuilder;
    private final JsonObjectBuilder claimsBuilder;
    private final Class<T> tokenType;

    public JWTBuilder() {
        this(JWT.class);
    }

    public JWTBuilder(Class<T> tokenType) {
        this.tokenType = tokenType;
        this.headersBuilder = Json.createObjectBuilder();
        this.claimsBuilder = Json.createObjectBuilder();
        this.type("JWT");
    }

    public B type(String type) {
        this.header("typ", type);
        return (B)this;
    }

    public B contentType(String contentType) {
        this.header("cty", contentType);
        return (B)this;
    }

    public B id(String id) {
        this.claim("jti", id);
        return (B)this;
    }

    public B issuer(String issuer) {
        this.claim("iss", issuer);
        return (B)this;
    }

    public B audience(String ... audience) {
        if (audience.length == 1) {
            this.claim("aud", audience[0]);
        } else if (audience.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String aud : audience) {
                arrayBuilder.add(aud);
            }
            this.claimsBuilder.add("aud", arrayBuilder);
        }
        return (B)this;
    }

    public B subject(String subject) {
        this.claim("sub", subject);
        return (B)this;
    }

    public B issuedAt(int issuedAt) {
        this.claim("iat", issuedAt);
        return (B)this;
    }

    public B expiration(int expirationTime) {
        this.claim("exp", expirationTime);
        return (B)this;
    }

    public B notBefore(int notBefore) {
        this.claim("nbf", notBefore);
        return (B)this;
    }

    public B claim(String name, String ... value) {
        this.setString(this.claimsBuilder, name, value);
        return (B)this;
    }

    public B claim(String name, int ... value) {
        this.setInt(this.claimsBuilder, name, value);
        return (B)this;
    }

    public B header(String name, String ... value) {
        this.setString(this.headersBuilder, name, value);
        return (B)this;
    }

    public B header(String name, int ... value) {
        this.setInt(this.headersBuilder, name, value);
        return (B)this;
    }

    public B header(String name, List<JsonObject> value) {
        this.setJsonObject(this.headersBuilder, name, value);
        return (B)this;
    }

    public B header(String name, JsonArray value) {
        this.setJsonObject(this.headersBuilder, name, value);
        return (B)this;
    }

    public T build() {
        return this.build(this.headersBuilder.build(), this.claimsBuilder.build());
    }

    public T build(String json) {
        if (!json.contains(".")) {
            throw JsonMessages.MESSAGES.invalidFormat(json);
        }
        String[] portions = json.split("\\.");
        byte[] header = JsonUtil.b64Decode(portions[0]);
        byte[] claims = JsonUtil.b64Decode(portions[1]);
        return this.build(Json.createReader((InputStream)new ByteArrayInputStream(header)).readObject(), Json.createReader((InputStream)new ByteArrayInputStream(claims)).readObject());
    }

    protected JsonObjectBuilder getClaimsBuilder() {
        return this.claimsBuilder;
    }

    protected JsonObjectBuilder getHeadersBuilder() {
        return this.headersBuilder;
    }

    protected Class<T> getTokenType() {
        return this.tokenType;
    }

    protected T build(JsonObject headersObject, JsonObject claimsObject) {
        try {
            Constructor<T> constructor = this.tokenType.getDeclaredConstructor(JsonObject.class, JsonObject.class);
            constructor.setAccessible(true);
            return (T)((JWT)constructor.newInstance(headersObject, claimsObject));
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.couldNotCreateToken(this.tokenType, e);
        }
    }

    private B setString(JsonObjectBuilder builder, String name, String ... values) {
        if (values.length == 1) {
            builder.add(name, values[0]);
        } else if (values.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String value : values) {
                arrayBuilder.add(value.toString());
            }
            builder.add(name, arrayBuilder);
        }
        return (B)this;
    }

    private B setInt(JsonObjectBuilder builder, String name, int ... values) {
        if (values.length == 1) {
            builder.add(name, values[0]);
        } else if (values.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int value : values) {
                arrayBuilder.add(value);
            }
            builder.add(name, arrayBuilder);
        }
        return (B)this;
    }

    private B setJsonObject(JsonObjectBuilder builder, String name, List<JsonObject> values) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        Iterator<JsonObject> iterator = values.iterator();
        while (iterator.hasNext()) {
            arrayBuilder.add((JsonValue)iterator.next());
        }
        builder.add(name, arrayBuilder);
        return (B)this;
    }

    private B setJsonObject(JsonObjectBuilder builder, String name, JsonArray values) {
        builder.add(name, (JsonValue)values);
        return (B)this;
    }
}

