/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.JWK;
import org.picketlink.json.util.JsonUtil;

public class JWKBuilder<T extends JWK, B extends JWKBuilder<?, ?>> {
    private final JsonObjectBuilder keyParametersBuilder;
    private final Class<T> tokenType;

    public JWKBuilder() {
        this(JWK.class);
    }

    protected JWKBuilder(Class<T> tokenType) {
        this.tokenType = tokenType;
        this.keyParametersBuilder = Json.createObjectBuilder();
    }

    public JWKBuilder<T, B> keyType(String type) {
        this.keyParameter("kty", type);
        return this;
    }

    public JWKBuilder<T, B> keyUse(String use) {
        this.keyParameter("use", use);
        return this;
    }

    public JWKBuilder<T, B> keyOperations(String ... keyOperations) {
        if (keyOperations.length == 1) {
            this.keyParameter("key_ops", keyOperations[0]);
        } else if (keyOperations.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String operation : keyOperations) {
                arrayBuilder.add(operation);
            }
            this.keyParametersBuilder.add("key_ops", arrayBuilder);
        }
        return this;
    }

    public JWKBuilder<T, B> keyAlgorithm(String algorithm) {
        this.keyParameter("alg", algorithm);
        return this;
    }

    public JWKBuilder<T, B> keyIdentifier(String identifier) {
        this.keyParameter("kid", identifier);
        return this;
    }

    public JWKBuilder<T, B> X509Url(String url) {
        this.keyParameter("x5u", url);
        return this;
    }

    public JWKBuilder<T, B> X509CertificateChain(String ... X509CertificateChain) {
        if (X509CertificateChain.length == 1) {
            this.keyParameter("x5c", X509CertificateChain[0]);
        } else if (X509CertificateChain.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String certificate : X509CertificateChain) {
                arrayBuilder.add(certificate);
            }
            this.keyParametersBuilder.add("x5c", arrayBuilder);
        }
        return this;
    }

    public JWKBuilder<T, B> X509CertificateSHA1Thumbprint(String sha1Thumbprint) {
        this.keyParameter("x5t", sha1Thumbprint);
        return this;
    }

    public JWKBuilder<T, B> X509CertificateSHA256Thumbprint(String sha256Thumbprint) {
        this.keyParameter("x5t#S256", sha256Thumbprint);
        return this;
    }

    public JWKBuilder<T, B> modulus(BigInteger modulus) {
        this.keyParameter("n", JsonUtil.b64Encode(modulus.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> publicExponent(BigInteger publicExponent) {
        this.keyParameter("e", JsonUtil.b64Encode(publicExponent.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> privateExponent(BigInteger privateExponent) {
        this.keyParameter("d", JsonUtil.b64Encode(privateExponent.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> primeP(BigInteger primeP) {
        this.keyParameter("p", JsonUtil.b64Encode(primeP.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> primeQ(BigInteger primeQ) {
        this.keyParameter("q", JsonUtil.b64Encode(primeQ.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> primeExponentP(BigInteger primeExponentP) {
        this.keyParameter("dp", JsonUtil.b64Encode(primeExponentP.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> primeExponentQ(BigInteger primeExponentQ) {
        this.keyParameter("dq", JsonUtil.b64Encode(primeExponentQ.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> crtCoefficient(BigInteger crtCoefficient) {
        this.keyParameter("qi", JsonUtil.b64Encode(crtCoefficient.toByteArray()));
        return this;
    }

    public JWKBuilder<T, B> keyParameter(String name, String ... value) {
        this.setString(this.keyParametersBuilder, name, value);
        return this;
    }

    public T build() {
        return this.build(this.keyParametersBuilder.build());
    }

    public T build(String json) {
        return this.build(Json.createReader((InputStream)new ByteArrayInputStream(json.getBytes())).readObject());
    }

    protected JsonObjectBuilder getkeyParametersBuilder() {
        return this.keyParametersBuilder;
    }

    protected Class<T> getTokenType() {
        return this.tokenType;
    }

    protected T build(JsonObject keyParametersObject) {
        try {
            Constructor<T> constructor = this.tokenType.getDeclaredConstructor(JsonObject.class);
            constructor.setAccessible(true);
            return (T)((JWK)constructor.newInstance(keyParametersObject));
        }
        catch (Exception e) {
            throw JsonMessages.MESSAGES.couldNotCreateToken(this.tokenType, e);
        }
    }

    private JWKBuilder<T, B> setString(JsonObjectBuilder builder, String name, String ... values) {
        if (values.length == 1) {
            builder.add(name, values[0]);
        } else if (values.length > 1) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String value : values) {
                arrayBuilder.add(value.toString());
            }
            builder.add(name, arrayBuilder);
        }
        return this;
    }
}

