/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.lang.reflect.Constructor;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.picketlink.json.JsonException;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.JWK;
import org.picketlink.json.jose.JWKSet;
import org.picketlink.json.jose.JWS;
import org.picketlink.json.jose.crypto.Algorithm;
import org.picketlink.json.jwt.JWTBuilder;
import org.picketlink.json.util.JsonUtil;

public abstract class AbstractJWSBuilder<T extends JWS, B extends AbstractJWSBuilder<T, B>>
extends JWTBuilder<T, B> {
    private byte[] key;

    protected AbstractJWSBuilder(Class<T> tokenType) {
        super(tokenType);
        this.header("alg", Algorithm.NONE.getAlgorithm());
    }

    public B kid(String kid) {
        this.header("kid", kid);
        return (B)this;
    }

    public B hmac256(byte[] key) {
        this.header("alg", Algorithm.HS256.name());
        this.key = key;
        return (B)this;
    }

    public B hmac384(byte[] key) {
        this.header("alg", Algorithm.HS384.name());
        this.key = key;
        return (B)this;
    }

    public B hmac512(byte[] key) {
        this.header("alg", Algorithm.HS512.name());
        this.key = key;
        return (B)this;
    }

    public B rsa256(byte[] key) {
        this.header("alg", Algorithm.RS256.name());
        this.key = key;
        return (B)this;
    }

    public B rsa384(byte[] key) {
        this.header("alg", Algorithm.RS384.name());
        this.key = key;
        return (B)this;
    }

    public B rsa512(byte[] key) {
        this.header("alg", Algorithm.RS512.name());
        this.key = key;
        return (B)this;
    }

    public B keys(JWKSet keySet) {
        this.header("keys", keySet.getJsonObject().getJsonArray("keys"));
        return (B)this;
    }

    public B keys(JWK ... keys) {
        JWKSet jwkSet = new JWKSet(keys);
        return this.keys(jwkSet);
    }

    @Override
    protected T build(JsonObject headersObject, JsonObject claimsObject) {
        try {
            Constructor constructor = this.getTokenType().getDeclaredConstructor(JsonObject.class, JsonObject.class, byte[].class);
            constructor.setAccessible(true);
            return (T)((JWS)constructor.newInstance(headersObject, claimsObject, this.key));
        }
        catch (Exception nsme) {
            throw JsonMessages.MESSAGES.couldNotCreateToken(this.getTokenType(), nsme);
        }
    }

    @Override
    public T build(String json) throws JsonException {
        JsonValue keysHeader;
        JWS uncheckedToken = (JWS)super.build(json);
        String keyId = uncheckedToken.getHeader("kid");
        if (keyId != null && (keysHeader = (JsonValue)uncheckedToken.getHeaders().get((Object)"keys")) != null && JsonValue.ValueType.ARRAY.equals((Object)keysHeader.getValueType())) {
            JWKSet jwkSet = new JWKSet((JsonArray)keysHeader);
            JWK jwk = jwkSet.get(keyId);
            if (!"RSA".equals(jwk.getKeyType())) {
                throw JsonMessages.MESSAGES.cryptoUnsupportedKey(jwk.getKeyType());
            }
            try {
                this.key = jwk.toRSAPublicKey().getEncoded();
            }
            catch (Exception e) {
                throw JsonMessages.MESSAGES.cryptoCouldNotParseKey(jwk.toString(), e);
            }
        }
        if (this.key == null) {
            return (T)uncheckedToken;
        }
        return this.build(json, this.key);
    }

    public T build(String json, byte[] key) throws JsonException {
        if (key == null) {
            throw JsonMessages.MESSAGES.invalidNullArgument("Encoded Public Key.");
        }
        JWS token = (JWS)super.build(json);
        Algorithm algorithm = Algorithm.resolve(token.getAlgorithm().toUpperCase());
        if (!algorithm.isNone()) {
            String[] portions = json.split("\\.");
            if (portions.length < 2) {
                throw JsonMessages.MESSAGES.cryptoSignatureNotPresent(json);
            }
            byte[] payload = json.substring(0, json.lastIndexOf(".")).getBytes();
            byte[] signature = JsonUtil.b64Decode(portions[2]);
            boolean validSignature = algorithm.getSignatureProvider().verify(payload, algorithm, signature, key);
            if (!validSignature) {
                throw JsonMessages.MESSAGES.cryptoInvalidSignature(json);
            }
        }
        return (T)token;
    }
}

