/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal.el;

import org.picketlink.Identity;
import org.picketlink.authorization.util.AuthorizationUtil;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.Account;
import org.picketlink.internal.el.ELEvaluationContext;

public class ELFunctionMethods {
    public static boolean isLoggedIn() {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        return AuthorizationUtil.isLoggedIn((Identity)identity);
    }

    public static boolean hasPermission(Object resource, String operation) {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        return AuthorizationUtil.hasPermission((Identity)identity, (Object)resource, (String)operation);
    }

    public static boolean hasRole(String roleName) {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        PartitionManager partitionManager = evaluationContext.getPartitionManager();
        IdentityManager identityManager = evaluationContext.getIdentityManager();
        RelationshipManager relationshipManager = evaluationContext.getRelationshipManager();
        return AuthorizationUtil.hasRole((Identity)identity, (PartitionManager)partitionManager, (IdentityManager)identityManager, (RelationshipManager)relationshipManager, (String)roleName);
    }

    public static boolean isMember(String groupName) {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        IdentityManager identityManager = evaluationContext.getIdentityManager();
        PartitionManager partitionManager = evaluationContext.getPartitionManager();
        RelationshipManager relationshipManager = evaluationContext.getRelationshipManager();
        return AuthorizationUtil.isMember((Identity)identity, (PartitionManager)partitionManager, (IdentityManager)identityManager, (RelationshipManager)relationshipManager, (String)groupName);
    }

    public static boolean hasAttribute(String attributeName) {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        Account account = identity.getAccount();
        return account != null && account.getAttribute(attributeName) != null;
    }

    public static boolean hasPartition(String partitionName) {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        Identity identity = evaluationContext.getIdentity();
        return AuthorizationUtil.hasPartition((Identity)identity, null, (String[])new String[]{partitionName});
    }
}

