/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.rest;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.picketlink.identity.federation.bindings.wildfly.rest.STSEndpoint;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.web.util.PostBindingUtil;

@Path(value="/saml")
public class SAMLEndpoint
extends STSEndpoint {
    @POST
    public Response generateAssertion(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null) {
            return Response.status((int)403).build();
        }
        SAMLProtocolContext samlProtocolContext = this.getSAMLProtocolContext(principal.getName());
        AssertionType assertionType = this.issueSAMLAssertion(samlProtocolContext);
        String base64EncodedAssertion = PostBindingUtil.base64Encode((String)AssertionUtil.asString((AssertionType)assertionType));
        return Response.status((int)200).entity((Object)base64EncodedAssertion).build();
    }
}

