/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.PrivateKey;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Response;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.bindings.tomcat.sp.AbstractSPFormAuthenticator;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class ServiceProviderAuthenticator
extends AbstractSPFormAuthenticator {
    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        if (this.isHttpPostBinding()) {
            this.sendHttpPostBindingRequest(destination, samlDocument, relayState, response, willSendRequest);
        } else {
            this.sendHttpRedirectRequest(destination, samlDocument, relayState, response, willSendRequest);
        }
    }

    private void sendHttpRedirectRequest(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws IOException, UnsupportedEncodingException, ProcessingException, ConfigurationException {
        String destinationQueryString = null;
        String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
        String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMessage.getBytes("UTF-8"));
        destinationQueryString = this.doSupportSignature() ? this.getSignedDestinationQueryString(base64Request, relayState, willSendRequest) : RedirectBindingUtil.getDestinationQueryString((String)base64Request, (String)relayState, (boolean)willSendRequest);
        RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
        holder.setDestination(destination).setDestinationQueryString(destinationQueryString);
        HTTPRedirectUtil.sendRedirectForRequestor((String)RedirectBindingUtil.getDestinationURL((RedirectBindingUtil.RedirectBindingUtilDestHolder)holder), (HttpServletResponse)response);
    }

    private void sendHttpPostBindingRequest(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws TrustKeyProcessingException, ProcessingException, IOException, ConfigurationException {
        if (this.doSupportSignature()) {
            SAML2Signature samlSignature = new SAML2Signature();
            KeyPair keypair = this.keyManager.getSigningKeyPair();
            samlSignature.signSAMLDocument(samlDocument, keypair);
        }
        String samlMessage = PostBindingUtil.base64Encode((String)DocumentUtil.getDocumentAsString((Document)samlDocument));
        DestinationInfoHolder destinationHolder = new DestinationInfoHolder(destination, samlMessage, relayState);
        PostBindingUtil.sendPost((DestinationInfoHolder)destinationHolder, (HttpServletResponse)response, (boolean)willSendRequest);
    }

    private String getSignedDestinationQueryString(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            if (signingKey == null) {
                this.log.error((Object)"Signing key is null. Check your KeyStore configuration.");
                throw new RuntimeException("PL00100: Signing Process Failure:");
            }
            String url = null;
            url = sendRequest ? RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature((String)urlEncodedRequest, (String)urlEncodedRelayState, (PrivateKey)signingKey) : RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature((String)urlEncodedRequest, (String)urlEncodedRelayState, (PrivateKey)signingKey);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

