package org.phenopackets.phenopackettools.validator.jsonschema;

import org.phenopackets.phenopackettools.validator.core.ValidationLevel;
import org.phenopackets.phenopackettools.validator.core.ValidationResult;
import org.phenopackets.phenopackettools.validator.core.ValidatorInfo;

/**
 * This class represents an error encountered during JSON Schema validation.
 * @param category an error category such as required, enum, additionalProperties
 * @param message The error message generated by the JSON Schema validation library
 * @author Peter N Robinson
 */
record JsonError(String category,
                        String message) implements ValidationResult {
    // TODO - find an appropriate location for this record or delete.

    /** JSON schema error meaning that the JSON code contained a property not present in the schema. */
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    /** JSON schema error meaning that the JSON code failed to contain a property required by the schema. */
    public static final String REQUIRED = "required";
    /** JSON schema error meaning that a field is used that is not defined in the corresponding enum. */
    public static final String ENUM = "enum";
    /** Another kind of JSON error. */
    public static final String UNKNOWN = "unknown";


    @Override
    public ValidatorInfo validatorInfo() {
        return null;
    }

    @Override
    public ValidationLevel level() {
        return null;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public String message() {
        return this.message;
    }



    public static JsonError additionalProperties(String message) {
        return new JsonError(ADDITIONAL_PROPERTIES, message);
    }

    public static JsonError required(String message) {
        return new JsonError(REQUIRED, message);
    }

    public static JsonError unknown(String message) {
        return new JsonError(UNKNOWN, message);
    }
}
