/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.utils.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TraceRow {
    private final String systemName;
    private final String categoryName;
    private final Long rowID;
    private final Long parentRowID;
    private final long duration;
    private final long sqlDuration;
    private final long startTime;
    private final long endTime;
    private final List<TraceRow> children = new ArrayList<TraceRow>();

    public TraceRow(String systemName, String categoryName, Long rowID, Long parentRowID, long duration, long sqlDuration, long startTime, long endTime) {
        this.systemName = systemName;
        this.categoryName = categoryName;
        this.rowID = rowID;
        this.parentRowID = parentRowID;
        this.duration = duration;
        this.sqlDuration = sqlDuration;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static TraceRow fromResultSet(ResultSet rs) throws SQLException {
        Object r = rs.getObject("TraceRowID");
        Object pr = rs.getObject("ParentRowID");
        Long rowID = Long.parseLong(r.toString());
        Long parentRowID = pr != null ? Long.valueOf(Long.parseLong(pr.toString())) : null;
        return new TraceRow(rs.getString("SystemName").trim(), rs.getString("CategoryName").trim(), rowID, parentRowID, rs.getLong("Duration"), rs.getLong("SQLDuration"), rs.getTimestamp("StartTime").getTime(), rs.getTimestamp("EndTime").getTime());
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public Long getRowID() {
        return this.rowID;
    }

    public Long getParentRowID() {
        return this.parentRowID;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getSqlDuration() {
        return this.sqlDuration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<TraceRow> getChildren() {
        return this.children;
    }

    public String toString() {
        return "TraceRow [systemName=" + this.systemName + ", categoryName=" + this.categoryName + ", rowID=" + this.rowID + ", parentRowID=" + this.parentRowID + ", duration=" + this.duration + ", sqlDurations=" + this.sqlDuration + ", startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }
}

