/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.utils.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.perfmon4j.util.JDBCHelper;
import org.perfmon4j.utils.sql.TraceRow;

public class PrintThreadTrace {
    private static DateFormat ROOT_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:sss:SSS");
    private static DateFormat CHILD_FORMAT = new SimpleDateFormat("HH:mm:sss:SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 6) {
            PrintThreadTrace.printUsage();
        } else {
            String jarFileName = args[0];
            String jdbcURL = args[1];
            String driverClassName = args[2];
            String userName = args[3];
            String password = args[4];
            long targetTraceID = Integer.parseInt(args[5]);
            ArrayList<TraceRow> rootList = new ArrayList<TraceRow>();
            HashMap<Long, TraceRow> directory = new HashMap<Long, TraceRow>();
            targetTraceID = 356043L;
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = JDBCHelper.createJDBCConnection((JDBCHelper.DriverCache)new JDBCHelper.DriverCache(), (String)driverClassName, (String)jarFileName, (String)jdbcURL, (String)userName, (String)password);
                String sql = "SELECT \ts.SystemName, \tc.CategoryName, \ttt.TraceRowID, \ttt.ParentRowID, \ttt.Duration, \ttt.SQLDuration, \ttt.startTime,  tt.endTime FROM P4JThreadTrace tt JOIN P4JSystem s ON s.SystemID = tt.SystemID JOIN P4JCategory c ON c.CategoryID = tt.CategoryID WHERE tt.TraceRowID >= " + targetTraceID + " AND tt.TraceRowID < " + (targetTraceID + 1000L) + " ORDER BY TraceRowID ASC";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    TraceRow row = TraceRow.fromResultSet(rs);
                    Long rowID = row.getRowID();
                    Long parentRowID = row.getParentRowID();
                    directory.put(rowID, row);
                    if (parentRowID == null) {
                        if (rowID != targetTraceID) continue;
                        rootList.add(row);
                        continue;
                    }
                    TraceRow parent = (TraceRow)directory.get(parentRowID);
                    if (parent == null) continue;
                    parent.getChildren().add(row);
                }
                for (TraceRow r : rootList) {
                    PrintThreadTrace.dumpTrace(r, "");
                }
                JDBCHelper.closeNoThrow((Connection)conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                JDBCHelper.closeNoThrow(conn);
            }
        }
    }

    private static void dumpTrace(TraceRow trace, String indention) {
        String end;
        String start;
        boolean isRoot;
        boolean bl = isRoot = trace.getParentRowID() == null;
        if (isRoot) {
            start = ROOT_FORMAT.format(new Date(trace.getStartTime()));
            end = ROOT_FORMAT.format(new Date(trace.getEndTime()));
        } else {
            start = CHILD_FORMAT.format(new Date(trace.getStartTime()));
            end = CHILD_FORMAT.format(new Date(trace.getEndTime()));
        }
        System.out.println(indention + "+" + start + " (" + trace.getDuration() + ") " + trace.getCategoryName());
        for (TraceRow c : trace.getChildren()) {
            PrintThreadTrace.dumpTrace(c, indention + "|   ");
        }
        System.out.println(indention + "+" + end + " " + trace.getCategoryName());
    }

    public static void printUsage() {
        System.out.println("Usage: [optionalParameters]");
        System.out.println("\tPrintThreadTrace: driverJarFile driverClassName jdbcURL userName password [schemaName=] [systemName=]");
    }
}

