/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.utils.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseTextAppenderLog {
    private static final Pattern HEADER_PATTERN = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})\\s.+org\\.perfmon4j\\.TextAppender");
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("(\\S*)");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\*{20,80}");
    private static final Pattern START_END_TIME_PATTERN = Pattern.compile("(\\d{2}:\\d{2}:\\d{2}:\\d{3}) -\\> (\\d{2}:\\d{2}:\\d{2}:\\d{3})");
    private static final Pattern SINGLE_NUMBER_PATTERN = Pattern.compile("(\\d+\\.?\\d*)");
    private static final Pattern THRESHOLD_PATTERN = Pattern.compile(" > (\\d+\\.?\\d* [^\\.]*)\\D*(\\d+\\.?\\d*)\\%");
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String CSV_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParse(File inputFile, File outputFile, String systemName) throws IOException {
        try (PrintStream out = new PrintStream(outputFile);){
            this.doParse(inputFile, out, systemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParse(File inputFile, PrintStream out, String systemName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
            this.doParse(reader, out, systemName);
        }
        out.flush();
    }

    void doParse(BufferedReader in, PrintStream out, String systemName) throws IOException {
        Writer writer = new Writer(out, systemName);
        Thread writerThread = new Thread(writer);
        writerThread.start();
        IntervalVO data = null;
        while (in.ready()) {
            data = ParseTextAppenderLog.getNextElement(in);
            if (data == null) continue;
            writer.queueForWrite(data);
        }
        writer.stopWhenEmpty();
        try {
            writerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (writer.isAborted()) {
            throw writer.getAbortException();
        }
    }

    static IntervalVO getNextElement(BufferedReader in) throws IOException {
        boolean abort = false;
        IntervalVO result = null;
        String date = ParseTextAppenderLog.getHeader(in.readLine());
        String category = null;
        String startTime = null;
        String endTime = null;
        String maxActiveThreads = null;
        String throughput = null;
        String averageDuration = null;
        String medianDuration = null;
        String standardDeviation = null;
        String maxDuration = null;
        String minDuration = null;
        String totalHits = null;
        String totalCompletions = null;
        String sqlAverageDuration = null;
        String sqlStandardDeviation = null;
        String sqlMaxDuration = null;
        String sqlMinDuration = null;
        boolean bl = abort = date == null;
        if (!abort) {
            boolean bl2 = abort = !ParseTextAppenderLog.isSeparator(in.readLine());
        }
        if (!abort) {
            category = ParseTextAppenderLog.getCategory(in.readLine());
            boolean bl3 = abort = category == null;
        }
        if (!abort) {
            String[] startEndTime = ParseTextAppenderLog.getStartEndTimes(in.readLine());
            if (startEndTime != null) {
                startTime = date + " " + startEndTime[0];
                endTime = date + " " + startEndTime[1];
            } else {
                abort = true;
            }
        }
        if (!abort) {
            maxActiveThreads = ParseTextAppenderLog.getSingleNumber("Max Active Threads", in.readLine());
            boolean bl4 = abort = maxActiveThreads == null;
        }
        if (!abort) {
            throughput = ParseTextAppenderLog.getSingleNumber("Throughput", in.readLine());
            boolean bl5 = abort = throughput == null;
        }
        if (!abort) {
            averageDuration = ParseTextAppenderLog.getSingleNumber("Average Duration", in.readLine());
            boolean bl6 = abort = averageDuration == null;
        }
        if (!abort) {
            medianDuration = ParseTextAppenderLog.getSingleNumber("Median Duration", in.readLine());
            boolean bl7 = abort = medianDuration == null;
        }
        if (!abort) {
            String nextLine = in.readLine();
            while (ParseTextAppenderLog.getThreshold(nextLine) != null) {
                nextLine = in.readLine();
            }
            standardDeviation = ParseTextAppenderLog.getSingleNumber("Standard Deviation", nextLine);
            boolean bl8 = abort = standardDeviation == null;
        }
        if (!abort) {
            maxDuration = ParseTextAppenderLog.getSingleNumber("Max Duration", in.readLine());
            boolean bl9 = abort = maxDuration == null;
        }
        if (!abort) {
            minDuration = ParseTextAppenderLog.getSingleNumber("Min Duration", in.readLine());
            boolean bl10 = abort = minDuration == null;
        }
        if (!abort) {
            totalHits = ParseTextAppenderLog.getSingleNumber("Total Hits", in.readLine());
            boolean bl11 = abort = totalHits == null;
        }
        if (!abort) {
            totalCompletions = ParseTextAppenderLog.getSingleNumber("Total Completions", in.readLine());
            boolean bl12 = abort = totalCompletions == null;
        }
        if (!abort && (sqlAverageDuration = ParseTextAppenderLog.getSingleNumber("(SQL)Avg. Duration", in.readLine())) != null) {
            sqlStandardDeviation = ParseTextAppenderLog.getSingleNumber("(SQL)Std. Dev", in.readLine());
            boolean bl13 = abort = sqlStandardDeviation == null;
            if (!abort) {
                sqlMaxDuration = ParseTextAppenderLog.getSingleNumber("(SQL)Max Duration", in.readLine());
                boolean bl14 = abort = sqlMaxDuration == null;
            }
            if (!abort) {
                sqlMinDuration = ParseTextAppenderLog.getSingleNumber("(SQL)Min Duration", in.readLine());
                boolean bl15 = abort = sqlMinDuration == null;
            }
        }
        if (!abort) {
            result = new IntervalVO();
            try {
                result.setStartAndEndTime(startTime, endTime);
                result.setCategory(category);
                result.setMaxActiveThreads(Long.parseLong(maxActiveThreads));
                result.setThroughput(Double.parseDouble(throughput));
                result.setAverageDuration(Double.parseDouble(averageDuration));
                result.setStandardDeviation(Double.parseDouble(standardDeviation));
                result.setMaxDuration(Long.parseLong(maxDuration));
                result.setMinDuration(Long.parseLong(minDuration));
                result.setTotalHits(Long.parseLong(totalHits));
                result.setTotalCompletions(Long.parseLong(totalCompletions));
                if (!"NA".equals(medianDuration)) {
                    result.setMedianDuration(Double.parseDouble(medianDuration));
                }
                if (sqlAverageDuration != null) {
                    result.setSqlAverageDuration(Double.parseDouble(sqlAverageDuration));
                    result.setSqlStandardDeviation(Double.parseDouble(sqlStandardDeviation));
                    result.setSqlMaxDuration(Long.parseLong(sqlMaxDuration));
                    result.setSqlMinDuration(Long.parseLong(sqlMinDuration));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    static boolean isSeparator(String line) {
        boolean result = false;
        if (line != null) {
            Matcher m = SEPARATOR_PATTERN.matcher(line);
            result = m.matches();
        }
        return result;
    }

    static String[] getThreshold(String line) {
        Matcher m;
        String[] result = null;
        if (line != null && line.trim().startsWith(">") && (m = THRESHOLD_PATTERN.matcher(line)).find()) {
            result = new String[]{m.group(1), m.group(2)};
        }
        return result;
    }

    static String getSingleNumber(String label, String line) {
        String result = null;
        if (line != null && line.trim().startsWith(label)) {
            Matcher m = SINGLE_NUMBER_PATTERN.matcher(line);
            result = m.find() ? m.group(1) : "NA";
        }
        return result;
    }

    static String getHeader(String line) {
        Matcher m;
        String result = null;
        if (line != null && (m = HEADER_PATTERN.matcher(line)).find()) {
            result = m.group(1);
        }
        return result;
    }

    static String getCategory(String line) {
        Matcher m;
        String result = null;
        if (line != null && (m = CATEGORY_PATTERN.matcher(line)).matches()) {
            result = m.group(1);
        }
        return result;
    }

    static String[] getStartEndTimes(String line) {
        Matcher m;
        String[] result = null;
        if (line != null && (m = START_END_TIME_PATTERN.matcher(line)).matches()) {
            result = new String[]{m.group(1), m.group(2)};
        }
        return result;
    }

    static long toTimestamp(String dateTime) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_STRING);
        return format.parse(dateTime).getTime();
    }

    static String fromTimestamp(long timestamp) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_STRING);
        return format.format(new Date(timestamp));
    }

    static String fromTimestampForCSV(long timestamp) {
        SimpleDateFormat format = new SimpleDateFormat(CSV_DATE_FORMAT_STRING);
        return format.format(new Date(timestamp));
    }

    static long decrementBy1Day(long timestamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(timestamp));
        ((Calendar)cal).add(5, -1);
        return cal.getTime().getTime();
    }

    static void write(IntervalVO data, PrintStream out, String systemName) throws IOException {
        out.println(data.toCSV(systemName));
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        ParseTextAppenderLog parser = new ParseTextAppenderLog();
        parser.doParse(new File("/media/sf_shared/NoBackup/FollettShelf/dap/pre_09-20-14.DAPX06"), new File("/media/sf_shared/NoBackup/pre_09-20-14_DAP6.csv"), "DAPNode6");
        System.out.println("DONE: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
    }

    public static class IntervalVO {
        private long startTime;
        private long endTime;
        private String category;
        private long maxActiveThreads;
        private double throughput;
        private double averageDuration;
        private Double medianDuration;
        private double standardDeviation;
        private long maxDuration;
        private long minDuration;
        private long totalHits;
        private long totalCompletions;
        private Double sqlAverageDuration;
        private Double sqlStandardDeviation;
        private Long sqlMaxDuration;
        private Long sqlMinDuration;

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartAndEndTime(String startTime, String endTime) throws ParseException {
            this.startTime = ParseTextAppenderLog.toTimestamp(startTime);
            this.endTime = ParseTextAppenderLog.toTimestamp(endTime);
            if (this.endTime < this.startTime) {
                this.startTime = ParseTextAppenderLog.decrementBy1Day(this.startTime);
            }
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getMaxActiveThreads() {
            return this.maxActiveThreads;
        }

        public void setMaxActiveThreads(long maxActiveThreads) {
            this.maxActiveThreads = maxActiveThreads;
        }

        public double getThroughput() {
            return this.throughput;
        }

        public void setThroughput(double throughput) {
            this.throughput = throughput;
        }

        public double getAverageDuration() {
            return this.averageDuration;
        }

        public void setAverageDuration(double averageDuration) {
            this.averageDuration = averageDuration;
        }

        public Double getMedianDuration() {
            return this.medianDuration;
        }

        public void setMedianDuration(Double medianDuration) {
            this.medianDuration = medianDuration;
        }

        public double getStandardDeviation() {
            return this.standardDeviation;
        }

        public void setStandardDeviation(double standardDeviation) {
            this.standardDeviation = standardDeviation;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public void setMaxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public void setMinDuration(long minDuration) {
            this.minDuration = minDuration;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public void setTotalHits(long totalHits) {
            this.totalHits = totalHits;
        }

        public long getTotalCompletions() {
            return this.totalCompletions;
        }

        public void setTotalCompletions(long totalCompletions) {
            this.totalCompletions = totalCompletions;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public Double getSqlAverageDuration() {
            return this.sqlAverageDuration;
        }

        public void setSqlAverageDuration(Double sqlAverageDuration) {
            this.sqlAverageDuration = sqlAverageDuration;
        }

        public Double getSqlStandardDeviation() {
            return this.sqlStandardDeviation;
        }

        public void setSqlStandardDeviation(Double sqlStandardDeviation) {
            this.sqlStandardDeviation = sqlStandardDeviation;
        }

        public Long getSqlMaxDuration() {
            return this.sqlMaxDuration;
        }

        public void setSqlMaxDuration(Long sqlMaxDuration) {
            this.sqlMaxDuration = sqlMaxDuration;
        }

        public Long getSqlMinDuration() {
            return this.sqlMinDuration;
        }

        public void setSqlMinDuration(Long sqlMinDuration) {
            this.sqlMinDuration = sqlMinDuration;
        }

        public static String buildCSVHeader() {
            return "SystemName,StartTime,EndTime,Category,MaxActiveThreads,Throughput,Average,Median,StandardDeviation,MaxDuration,MinDuration,TotalHits,TotalCompetions,SQLAverage,SQLStandardDeviation,SQLMaxDuration,SQLMinDuration";
        }

        public String toCSV(String systemName) {
            StringBuilder builder = new StringBuilder();
            builder.append(systemName).append(",").append(ParseTextAppenderLog.fromTimestampForCSV(this.startTime)).append(",").append(ParseTextAppenderLog.fromTimestampForCSV(this.endTime)).append(",").append(this.category).append(",").append(this.maxActiveThreads).append(",").append(this.throughput).append(",").append(this.averageDuration).append(",");
            if (this.medianDuration != null) {
                builder.append(this.medianDuration);
            } else {
                builder.append("-1");
            }
            builder.append(",");
            builder.append(this.standardDeviation).append(",").append(this.maxDuration).append(",").append(this.minDuration).append(",").append(this.totalHits).append(",").append(this.totalCompletions).append(",");
            if (this.sqlAverageDuration != null) {
                builder.append(this.sqlAverageDuration).append(",").append(this.sqlStandardDeviation).append(",").append(this.sqlMaxDuration).append(",").append(this.sqlMinDuration);
            } else {
                builder.append("-1,-1,-1,-1");
            }
            return builder.toString();
        }
    }

    private class Writer
    implements Runnable {
        private final PrintStream out;
        private final String systemName;
        private volatile boolean stopWhenEmpty = false;
        private volatile IOException abortException = null;
        private final ArrayBlockingQueue<IntervalVO> output = new ArrayBlockingQueue(100);

        Writer(PrintStream out, String systemName) {
            this.out = out;
            this.systemName = systemName;
        }

        @Override
        public void run() {
            boolean done = false;
            this.out.println(IntervalVO.buildCSVHeader());
            while (!done && this.abortException == null) {
                try {
                    IntervalVO d = this.output.poll(100L, TimeUnit.MILLISECONDS);
                    if (d != null) {
                        try {
                            ParseTextAppenderLog.write(d, this.out, this.systemName);
                        }
                        catch (IOException e) {
                            this.abortException = e;
                        }
                        continue;
                    }
                    done = this.stopWhenEmpty;
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopWhenEmpty() {
            this.stopWhenEmpty = true;
        }

        public boolean isAborted() {
            return this.abortException != null;
        }

        public IOException getAbortException() {
            return this.abortException;
        }

        public void queueForWrite(IntervalVO data) throws IOException {
            if (this.abortException == null) {
                try {
                    this.output.offer(data, 999L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw this.abortException;
            }
        }
    }
}

