/*
 * Decompiled with CFR 0.152.
 */
package org.perfmon4j.utils.chart.jfree;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ChartBuilderImpl {
    private final Random random = new Random();

    private Date addRandomMinute(TimeSeries througputSeries, TimeSeries maxThreadsSeries, Date date) {
        througputSeries.add((RegularTimePeriod)new Minute(date), this.random.nextDouble() * 12000.0);
        maxThreadsSeries.add((RegularTimePeriod)new Minute(date), this.random.nextDouble() * 600.0);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(12, -1);
        return cal.getTime();
    }

    public void buildChart() throws Exception {
        TimeSeries throughputSeries = new TimeSeries((Comparable)((Object)"Throughput"), Minute.class);
        TimeSeries maxThreadsSeries = new TimeSeries((Comparable)((Object)"MaxThreads"), Minute.class);
        Date date = new Date();
        for (int i = 0; i < 480; ++i) {
            date = this.addRandomMinute(throughputSeries, maxThreadsSeries, date);
        }
        TimeSeriesCollection througputDataSet = new TimeSeriesCollection();
        througputDataSet.addSeries(throughputSeries);
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"FollettShelf:WebRequest", (String)"Time", (String)"Throughput", (XYDataset)througputDataSet, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        TimeSeriesCollection maxThreadsDataSet = new TimeSeriesCollection();
        maxThreadsDataSet.addSeries(maxThreadsSeries);
        NumberAxis axis2 = new NumberAxis("Max Theads");
        plot.setRangeAxis(1, (ValueAxis)axis2);
        plot.setDataset(1, (XYDataset)maxThreadsDataSet);
        plot.mapDatasetToRangeAxis(1, 1);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        renderer2.setSeriesShapesVisible(0, Boolean.FALSE);
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        ChartUtilities.saveChartAsPNG((File)new File("/media/sf_shared/t/test.png"), (JFreeChart)chart, (int)600, (int)400);
    }

    public static void main(String[] args) throws Exception {
        new ChartBuilderImpl().buildChart();
    }
}

