/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.transformers;

import io.reactivex.rxjava3.core.ObservableOperator;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.observers.ResourceObserver;
import javafx.application.Platform;

public final class FxObservableTransformers {
    private FxObservableTransformers() {
    }

    private static <T> void runOnFx(T t, Consumer<T> consumer) {
        Platform.runLater(() -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    private static <T> void runOnFx(Action action) {
        Platform.runLater(() -> {
            try {
                action.run();
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    public static <T> ObservableTransformer<T, T> doOnNextFx(Consumer<T> onNext) {
        return obs -> obs.doOnNext(t -> FxObservableTransformers.runOnFx(t, onNext));
    }

    public static <T> ObservableTransformer<T, T> doOnErrorFx(Consumer<Throwable> onError) {
        return obs -> obs.doOnError(e -> FxObservableTransformers.runOnFx(e, onError));
    }

    public static <T> ObservableTransformer<T, T> doOnCompleteFx(Action onCompleted) {
        return obs -> obs.doOnComplete(() -> FxObservableTransformers.runOnFx(onCompleted));
    }

    public static <T> ObservableTransformer<T, T> doOnSubscribeFx(Consumer<Disposable> subscribe) {
        return obs -> obs.doOnSubscribe(d -> FxObservableTransformers.runOnFx(d, subscribe));
    }

    public static <T> ObservableTransformer<T, T> doOnTerminateFx(Action onTerminate) {
        return obs -> obs.doOnTerminate(() -> FxObservableTransformers.runOnFx(onTerminate));
    }

    public static <T> ObservableTransformer<T, T> doOnDisposeFx(Action onDipsose) {
        return obs -> obs.doOnDispose(() -> FxObservableTransformers.runOnFx(onDipsose));
    }

    public static <T> ObservableTransformer<T, T> doOnNextCount(Consumer<Integer> onNext) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(onNext, null, null)));
    }

    public static <T> ObservableTransformer<T, T> doOnCompleteCount(Consumer<Integer> onComplete) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(null, onComplete, null)));
    }

    public static <T> ObservableTransformer<T, T> doOnErrorCount(Consumer<Integer> onError) {
        return obs -> obs.lift(new OperatorEmissionCounter(new CountObserver(null, null, onError)));
    }

    public static <T> ObservableTransformer<T, T> doOnNextCountFx(Consumer<Integer> onNext) {
        return obs -> obs.compose(FxObservableTransformers.doOnNextCount((Consumer<Integer>)((Consumer)i -> FxObservableTransformers.runOnFx(i, onNext))));
    }

    public static <T> ObservableTransformer<T, T> doOnCompleteCountFx(Consumer<Integer> onComplete) {
        return obs -> obs.compose(FxObservableTransformers.doOnCompleteCount((Consumer<Integer>)((Consumer)i -> FxObservableTransformers.runOnFx(i, onComplete))));
    }

    public static <T> ObservableTransformer<T, T> doOnErrorCountFx(Consumer<Integer> onError) {
        return obs -> obs.compose(FxObservableTransformers.doOnErrorCount((Consumer<Integer>)((Consumer)i -> FxObservableTransformers.runOnFx(i, onError))));
    }

    private static final class CountObserver {
        private final Consumer<Integer> doOnNextCountAction;
        private final Consumer<Integer> doOnCompletedCountAction;
        private final Consumer<Integer> doOnErrorCountAction;

        CountObserver(Consumer<Integer> doOnNextCountAction, Consumer<Integer> doOnCompletedCountAction, Consumer<Integer> doOnErrorCountAction) {
            this.doOnNextCountAction = doOnNextCountAction;
            this.doOnCompletedCountAction = doOnCompletedCountAction;
            this.doOnErrorCountAction = doOnErrorCountAction;
        }
    }

    private static class OperatorEmissionCounter<T>
    implements ObservableOperator<T, T> {
        private final CountObserver ctObserver;

        OperatorEmissionCounter(CountObserver ctObserver) {
            this.ctObserver = ctObserver;
        }

        public Observer<? super T> apply(final Observer<? super T> child) {
            return new ResourceObserver<T>(){
                private int count = 0;
                private boolean done = false;

                public void onComplete() {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnCompletedCountAction != null) {
                            ctObserver.doOnCompletedCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    this.done = true;
                    child.onComplete();
                }

                public void onError(Throwable e) {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnErrorCountAction != null) {
                            ctObserver.doOnErrorCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e1) {
                        Exceptions.throwIfFatal((Throwable)e1);
                        child.onError(e1);
                    }
                }

                public void onNext(T t) {
                    if (this.done) {
                        return;
                    }
                    try {
                        ++this.count;
                        if (ctObserver.doOnNextCountAction != null) {
                            ctObserver.doOnNextCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    child.onNext(t);
                }
            };
        }
    }
}

