/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.transformers;

import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.subscribers.ResourceSubscriber;
import javafx.application.Platform;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FxFlowableTransformers {
    private FxFlowableTransformers() {
    }

    private static <T> void runOnFx(T t, Consumer<T> consumer) {
        Platform.runLater(() -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    private static <T> void runOnFx(Action action) {
        Platform.runLater(() -> {
            try {
                action.run();
            }
            catch (Throwable e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    public static <T> FlowableTransformer<T, T> doOnNextFx(Consumer<T> onNext) {
        return obs -> obs.doOnNext(t -> FxFlowableTransformers.runOnFx(t, onNext));
    }

    public static <T> FlowableTransformer<T, T> doOnErrorFx(Consumer<Throwable> onError) {
        return obs -> obs.doOnError(e -> FxFlowableTransformers.runOnFx(e, onError));
    }

    public static <T> FlowableTransformer<T, T> doOnCompleteFx(Action onCompleted) {
        return obs -> obs.doOnComplete(() -> FxFlowableTransformers.runOnFx(onCompleted));
    }

    public static <T> FlowableTransformer<T, T> doOnSubscribeFx(Consumer<Subscription> subscribe) {
        return obs -> obs.doOnSubscribe(d -> FxFlowableTransformers.runOnFx(d, subscribe));
    }

    public static <T> FlowableTransformer<T, T> doOnTerminateFx(Action onTerminate) {
        return obs -> obs.doOnTerminate(() -> FxFlowableTransformers.runOnFx(onTerminate));
    }

    public static <T> FlowableTransformer<T, T> doOnCancelFx(Action onDipsose) {
        return obs -> obs.doOnCancel(() -> FxFlowableTransformers.runOnFx(onDipsose));
    }

    public static <T> FlowableTransformer<T, T> doOnNextCount(Consumer<Integer> onNext) {
        return obs -> obs.lift(new FlowableEmissionCounter(new CountObserver(onNext, null, null)));
    }

    public static <T> FlowableTransformer<T, T> doOnCompleteCount(Consumer<Integer> onComplete) {
        return obs -> obs.lift(new FlowableEmissionCounter(new CountObserver(null, onComplete, null)));
    }

    public static <T> FlowableTransformer<T, T> doOnErrorCount(Consumer<Integer> onError) {
        return obs -> obs.lift(new FlowableEmissionCounter(new CountObserver(null, null, onError)));
    }

    public static <T> FlowableTransformer<T, T> doOnNextCountFx(Consumer<Integer> onNext) {
        return obs -> obs.compose(FxFlowableTransformers.doOnNextCount((Consumer<Integer>)((Consumer)i -> FxFlowableTransformers.runOnFx(i, onNext))));
    }

    public static <T> FlowableTransformer<T, T> doOnCompleteCountFx(Consumer<Integer> onComplete) {
        return obs -> obs.compose(FxFlowableTransformers.doOnCompleteCount((Consumer<Integer>)((Consumer)i -> FxFlowableTransformers.runOnFx(i, onComplete))));
    }

    public static <T> FlowableTransformer<T, T> doOnErrorCountFx(Consumer<Integer> onError) {
        return obs -> obs.compose(FxFlowableTransformers.doOnErrorCount((Consumer<Integer>)((Consumer)i -> FxFlowableTransformers.runOnFx(i, onError))));
    }

    private static final class CountObserver {
        private final Consumer<Integer> doOnNextCountAction;
        private final Consumer<Integer> doOnCompletedCountAction;
        private final Consumer<Integer> doOnErrorCountAction;

        CountObserver(Consumer<Integer> doOnNextCountAction, Consumer<Integer> doOnCompletedCountAction, Consumer<Integer> doOnErrorCountAction) {
            this.doOnNextCountAction = doOnNextCountAction;
            this.doOnCompletedCountAction = doOnCompletedCountAction;
            this.doOnErrorCountAction = doOnErrorCountAction;
        }
    }

    private static class FlowableEmissionCounter<T>
    implements FlowableOperator<T, T> {
        private final CountObserver ctObserver;

        FlowableEmissionCounter(CountObserver ctObserver) {
            this.ctObserver = ctObserver;
        }

        public Subscriber<? super T> apply(final Subscriber<? super T> child) {
            return new ResourceSubscriber<T>(){
                private int count = 0;
                private boolean done = false;

                protected void onStart() {
                    super.onStart();
                    this.request(Long.MAX_VALUE);
                }

                public void onComplete() {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnCompletedCountAction != null) {
                            ctObserver.doOnCompletedCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    this.done = true;
                    child.onComplete();
                }

                public void onError(Throwable e) {
                    if (this.done) {
                        return;
                    }
                    try {
                        if (ctObserver.doOnErrorCountAction != null) {
                            ctObserver.doOnErrorCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e1) {
                        Exceptions.throwIfFatal((Throwable)e1);
                        child.onError(e1);
                    }
                }

                public void onNext(T t) {
                    if (this.done) {
                        return;
                    }
                    try {
                        ++this.count;
                        if (ctObserver.doOnNextCountAction != null) {
                            ctObserver.doOnNextCountAction.accept((Object)this.count);
                        }
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        this.onError(e);
                        return;
                    }
                    child.onNext(t);
                    this.request(Long.MAX_VALUE);
                }
            };
        }
    }
}

