/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.rxjavafx.sources;

import io.reactivex.rxjava3.core.ObservableEmitter;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.pdfsam.rxjavafx.sources.Change;
import org.pdfsam.rxjavafx.subscriptions.JavaFxSubscriptions;

public class ObservableValueSource {
    public static <T> io.reactivex.rxjava3.core.Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return io.reactivex.rxjava3.core.Observable.create(emitter -> {
            if (fxObservable.getValue() != null) {
                emitter.onNext(fxObservable.getValue());
            }
            ChangeListener listener = (observableValue, prev, current) -> emitter.onNext(current);
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> io.reactivex.rxjava3.core.Observable<T> fromObservableValue(ObservableValue<T> fxObservable, T nullSentinel) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        return io.reactivex.rxjava3.core.Observable.create(emitter -> {
            if (fxObservable.getValue() != null) {
                emitter.onNext(fxObservable.getValue());
            }
            ChangeListener listener = (observableValue, prev, current) -> {
                if (current != null) {
                    emitter.onNext(current);
                } else {
                    emitter.onNext(nullSentinel);
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> io.reactivex.rxjava3.core.Observable<Optional<T>> fromNullableObservableValue(ObservableValue<T> fxObservable) {
        return io.reactivex.rxjava3.core.Observable.create(emitter -> {
            emitter.onNext(Optional.ofNullable(fxObservable.getValue()));
            ChangeListener listener = (observableValue, prev, current) -> emitter.onNext(Optional.ofNullable(current));
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> io.reactivex.rxjava3.core.Observable<Change<T>> fromObservableValueChanges(ObservableValue<T> fxObservable) {
        return io.reactivex.rxjava3.core.Observable.create(emitter -> {
            ChangeListener listener = (observableValue, prev, current) -> emitter.onNext(new Change<Object>(prev, current));
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static io.reactivex.rxjava3.core.Observable<Observable> fromInvalidations(Observable fxObservable) {
        return io.reactivex.rxjava3.core.Observable.create(emitter -> {
            InvalidationListener listener = arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0);
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }
}

